/*

 TreeNodePathUtil.java
 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on 2005/02/04

 */
package net.sf.sqs_xml.editor.base.swing;

import java.util.LinkedList;

import javax.swing.tree.TreePath;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * @author hiroya
 *
 */
public class TreeNodePathUtil {
    public static TreePath createTreePath(Node target){
        LinkedList list = new LinkedList();
        Node currentNode = target;
        while(currentNode != null){
            list.addFirst(currentNode);
            currentNode = currentNode.getParentNode();
          }
        return new TreePath(list.toArray());
    }
    
    public static final String PATH_SEPARATOR = "|"; 
    
    public static TreePath createTreePath(Node documentNode, String pathID){
        LinkedList list = new LinkedList();
        String args[] = pathID.split("\\"+PATH_SEPARATOR);
        Node node = ((org.w3c.dom.Document)documentNode).getFirstChild();
        list.add(documentNode);
        list.add(node);
        for(int i=2; i<args.length; i++){                    
            int index = Integer.parseInt(args[i]);
            node = ((Element)node).getChildNodes().item(index);
            list.add(node);
        }
        return new TreePath(list.toArray());
    }
    
    public static String createPathID(TreePath path){
        Object[] obj = path.getPath();
        String ret = "";
        for(int i=1; i<obj.length; i++){
            ret += PATH_SEPARATOR+getNodeIndex((Node)obj[i]);
        }
        return ret;
    }
    
    public static String createPathID(Node node){

        String ret = "";
        while(node.getParentNode() != null){
            ret = PATH_SEPARATOR+getNodeIndex(node)+ret;
            node = node.getParentNode(); 
        }
        return ret;
    }
    
    private static int getNodeIndex(Node node){
        if(node.getParentNode() != null){
            NodeList list = node.getParentNode().getChildNodes();
            for(int i=0; i<list.getLength(); i++){
                if(list.item(i) == node){
                    return i;
                }
              }
           }
         return -1;
    }
}
