/*

 TreeNodePopupMenu.java
 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on 2004/08/10

 */
package net.sf.sqs_xml.editor.base.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.List;

import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;

import org.w3c.dom.Element;
import org.w3c.dom.Node;

import net.sf.sqs_xml.util.StringUtil;

public class TreeNodePopupMenu extends JPopupMenu{
    public static final long serialVersionUID = 0;
    private final NodeTreePane treePane;
    private TreeNodePopupAdapter listener;
    private JMenuItem cutMenuItem, copyMenuItem;
    JMenuItem insertUpperMenu = null;
    JMenuItem insertWithinMenu = null;
    JMenuItem insertLowerMenu = null;
    public static String SELECTED_NODE = "選択したノード";
    public static String CLICKED_NODE = "クリックしたノード";
    String target = null;
    
    private TreeNodePopupMenu(NodeTreePane tree, boolean isClickedNode){
        this.treePane = tree;
        if(isClickedNode){
            target = CLICKED_NODE;
        }else{
            target = SELECTED_NODE;
          }
    }
    
    TreeNodePopupMenu(NodeTreePane tree, TreePath treePath, boolean isClickedNode){
        this(tree, isClickedNode);
        String pathID = TreeNodePathUtil.createPathID(treePath);
        listener = new TreeNodePopupAdapter(this, (Node)treePath.getPath()[0],
                pathID, isClickedNode);
        JMenuItem showAllMenuItem = createPopupMenuItem(target+"の「枝を表示」", "S "+pathID);
        JMenuItem hideAllMenuItem = createPopupMenuItem(target+"の「枝を隠す」", "H "+pathID);

        add(showAllMenuItem);
        add(hideAllMenuItem);
        addSeparator();

        this.cutMenuItem = createPopupMenuItem(target+"を「カット」", "d "+pathID);
        this.copyMenuItem = createPopupMenuItem(target+"を「コピー」", "c "+pathID);
        
        cutMenuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_X, ActionEvent.CTRL_MASK));
        copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_C, ActionEvent.CTRL_MASK));
        
        if(isReadOnly()){
           cutMenuItem.setEnabled(false);
        }
        add(cutMenuItem);
        add(copyMenuItem);
        addSeparator();
        insertUpperMenu = createPopupMenuItem("↑  "+CLICKED_NODE+"の「前」に貼り付け", "b "+pathID);
        insertWithinMenu = createPopupMenuItem("→  "+CLICKED_NODE+"の「枝」として貼り付け", "i "+pathID);
        insertLowerMenu = createPopupMenuItem("↓  "+CLICKED_NODE+"の「後」に貼り付け", "a "+pathID);
        insertLowerMenu.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_V, ActionEvent.CTRL_MASK));        
        add(insertUpperMenu);
        add(insertWithinMenu);
        add(insertLowerMenu);
        setPopupSize(300, 150);
        updateMenu();
    }
    /*
    TreeNodePopupMenu(NodeTreePane tree, int rowIndex, boolean isClickedNode){
        this(tree, isClickedNode);
        listener = new TreeNodePopupAdapter(this, rowIndex, isClickedNode);
        JMenuItem showAllMenuItem = createPopupMenuItem(target+"の「枝を表示」", "S "+rowIndex);
        JMenuItem hideAllMenuItem = createPopupMenuItem(target+"の「枝を隠す」", "H "+rowIndex);

        add(showAllMenuItem);
        add(hideAllMenuItem);
        addSeparator();

        this.cutMenuItem = createPopupMenuItem(target+"を「カット」", "d "+rowIndex);
        this.copyMenuItem = createPopupMenuItem(target+"を「コピー」", "c "+rowIndex);
        
        cutMenuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_X, ActionEvent.CTRL_MASK));
        copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_C, ActionEvent.CTRL_MASK));
        
        if(isReadOnly()){
           cutMenuItem.setEnabled(false);
        }
        add(cutMenuItem);
        add(copyMenuItem);
        addSeparator();
        insertUpperMenu = createPopupMenuItem("↑  "+CLICKED_NODE+"の「前」に貼り付け", "b "+rowIndex);
        insertWithinMenu = createPopupMenuItem("→  "+CLICKED_NODE+"の「枝」として貼り付け", "i "+rowIndex);
        insertLowerMenu = createPopupMenuItem("↓  "+CLICKED_NODE+"の「後」に貼り付け", "a "+rowIndex);
        insertLowerMenu.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_V, ActionEvent.CTRL_MASK));        
        add(insertUpperMenu);
        add(insertWithinMenu);
        add(insertLowerMenu);
        setPopupSize(300, 150);
        updateMenu();
    }
*/    
    public void show(Component invoker, int x, int y) {
        updateMenu();
        super.show(invoker, x, y);
    }
    
    public void updateMenu(){
        List recentCutNodes = treePane.mediator.menuBarMediator.getRecentCutNode();
        if(recentCutNodes != null && 0 < recentCutNodes.size()){
            setInsertMenuEnabled(true);            
        }else{
            setInsertMenuEnabled(false);
        }
        if(isReadOnly()){
            insertUpperMenu.setEnabled(false);
            insertWithinMenu.setEnabled(false);
            insertLowerMenu.setEnabled(false);
        }
    }

    private void setInsertMenuEnabled(boolean isEnabled){ 
        insertUpperMenu.setEnabled(isEnabled);
        insertWithinMenu.setEnabled(isEnabled);
        insertLowerMenu.setEnabled(isEnabled);
    }
    
    boolean isReadOnly() {
        return getTreePane().mediator.getSourceEditorTabbedPane().getCurrentEditingSource().isReadOnly();
    }

    public NodeTreePane getTreePane(){
        return treePane;
    }

    private JMenuItem createPopupMenuItem(String label, String command){
        JMenuItem item = new JMenuItem(label);
        item.setActionCommand(command);
        item.addActionListener(listener);
        return item;
    }
    
    public JMenuItem getCutMenuItem(){
        return cutMenuItem;
    }
    
    public JMenuItem getCopyMenuItem(){
        return copyMenuItem;
    }
}