/*

 SQSFileChooser.java
 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on 2004/08/21

 */
package net.sf.sqs_xml.editor.sqs.swing;

import java.io.File;

import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.metal.MetalIconFactory;

import net.sf.sqs_xml.editor.base.swing.SuffixBasedFileChooser;
import net.sf.sqs_xml.swing.IconFactory;
import net.sf.sqs_xml.swing.SuffixBasedFileFilter;
import net.sf.sqs_xml.swing.SwingUtil;


/**
 * @author hiroya
 *
 */
public class SQSFileChooser extends SuffixBasedFileChooser{
    public static final long serialVersionUID = 0;
    public static final String DEFAULT_FILENAME = "newfile"; 
    public static final String OPEN_SQSSOURCE_TITLE = "SQS Sourceファイルを開く";
    public static final String SAVE_SQSSOURCE_TITLE = "SQS Sourceファイルの別形式での書き出し";
    public static final String SAVE_SQSMASTER_TITLE = "SQS Masterファイルを保存する";
    public static final String SAVE_PDFMARKSHEET_TITLE = "PDF Fileを保存する";
    public static final String OPEN_SQSFOLDER_TITLE = "フォルダを開く";
    public static final String SAVE_RESULTFOLDER_TITLE = "フォルダに保存する";
    
    public static final String SQSSOURCE_DESCRIPTION = "調査票定義ファイル SQS Source(.sqs)";
    public static final String SQSFOLDER_DESCRIPTION = "フォルダ(スキャン画像と印刷原稿PDFファイルを含むもの)";
    public static final String SQSMASTER_DESCRIPTION = "SQS Masterファイル(.sqm)";
    public static final String HTMLFORM_DESCRIPTION = "Webブラウザ上での回答のためのHTMLフォーム (.html)";
    public static final String PDFMARKSHEET_DESCRIPTION = "マークシート式の調査票印刷原稿のPDF (.pdf)";
    public static final String RESULTFOLDER_DESCRIPTION = "フォルダ(集計結果データを保存)";
    
    static Icon sqsIcon;    
    static Icon pdfIcon;
    static Icon textImageIcon;
    static Icon srcImageIcon;
    static Icon treeFolderIcon;
    static Icon defaultFileIcon;
    static Icon csvIcon;
    
    String defaultSuffix;
    String baseuri;

    public SQSFileChooser(SuffixBasedFileFilter filter){
        super(filter);
        if(sqsIcon == null){
            pdfIcon = IconFactory.create("pdfdoc.gif");
            sqsIcon = IconFactory.create("sqs-tiny.gif");
            textImageIcon = IconFactory.create("image1.gif");
            srcImageIcon = IconFactory.create("image2.gif");
            csvIcon = IconFactory.create("csv.gif");
            treeFolderIcon = new MetalIconFactory.TreeFolderIcon();
            defaultFileIcon = new MetalIconFactory.TreeLeafIcon();
        }
    }
    
    public String getSuffix(){
        return ((SuffixBasedFileFilter)this.getFileFilter()).getSuffix();
    }
    
    public static JFileChooser createExportFileChooser(){
        SuffixBasedFileFilter pdfFilter = SwingUtil.createSuffixBasedFileFilter(".pdf", PDFMARKSHEET_DESCRIPTION);
        SuffixBasedFileFilter htmlFilter = SwingUtil.createSuffixBasedFileFilter(".html", HTMLFORM_DESCRIPTION);
        JFileChooser exportFileChooser = new SQSFileChooser(pdfFilter);
        exportFileChooser.setDialogTitle(SAVE_SQSSOURCE_TITLE);
        exportFileChooser.addChoosableFileFilter(htmlFilter);
        exportFileChooser.addChoosableFileFilter(pdfFilter);
        return exportFileChooser;
    }
    
   
    /**
     * @param title
     * @param selectedFile
     * @return
     */
    private static SuffixBasedFileChooser createFileChooser(String title, String suffix, String description, File selectedFile) {
        SuffixBasedFileFilter filter = SwingUtil.createSuffixBasedFileFilter(suffix, description);
        SuffixBasedFileChooser chooser = new SQSFileChooser(filter);
        chooser.setDialogTitle(title);
        if(selectedFile != null){
            if(selectedFile.isDirectory()){
                chooser.setSelectedFile(selectedFile.getParentFile());
            }else{
                chooser.setCurrentDirectory(selectedFile.getParentFile());//TODO
                chooser.setSelectedFile(selectedFile);
            }
        }else{
            if(suffix != null){
                chooser.setSelectedFile(new File(chooser.getCurrentDirectory().getAbsolutePath()+File.separator+DEFAULT_FILENAME+suffix));
            }
        }
        return chooser;
    }

    public static SuffixBasedFileChooser createOpenSQSSourceChooser(File selectedFile){
        return createFileChooser(OPEN_SQSSOURCE_TITLE, ".sqs", SQSSOURCE_DESCRIPTION, selectedFile);
    }
    
    public static SuffixBasedFileChooser createSaveSQSFileChooser(File selectedFile){
        return createFileChooser(SAVE_SQSSOURCE_TITLE, ".sqs", SQSSOURCE_DESCRIPTION, selectedFile); 
    }

    public static SuffixBasedFileChooser createSavePDFFileChooser(File selectedFile){
        return createFileChooser(SAVE_PDFMARKSHEET_TITLE, ".pdf", PDFMARKSHEET_DESCRIPTION, selectedFile); 
    }

    public static SuffixBasedFileChooser createSaveSQMFileChooser(File selectedFile){
        return createFileChooser(SAVE_SQSMASTER_TITLE, ".sqm", SQSMASTER_DESCRIPTION, selectedFile); 
    }
    
    public static SuffixBasedFileChooser createSaveReaderResultFolderChooser(File dir){
        SuffixBasedFileFilter folderFilter = SwingUtil.createSuffixBasedFileFilter(null, RESULTFOLDER_DESCRIPTION);
        SuffixBasedFileChooser sqsFolderChooser = new SQSFileChooser(null);
        sqsFolderChooser.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
		//sqsFolderChooser.setSelectedFile(dir);
		if(dir != null){
		    sqsFolderChooser.setCurrentDirectory(dir);
		}
		sqsFolderChooser.setDialogTitle(OPEN_SQSFOLDER_TITLE);
		sqsFolderChooser.addChoosableFileFilter(folderFilter);
	    return sqsFolderChooser;
	}

    public static SuffixBasedFileChooser createOpenSQSFolderChooser(File dir){
        SuffixBasedFileFilter folderFilter = SwingUtil.createSuffixBasedFileFilter(null, SQSFOLDER_DESCRIPTION);
        SuffixBasedFileChooser sqsFolderChooser = new SQSFileChooser(null);
        sqsFolderChooser.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
		//sqsFolderChooser.setSelectedFile(dir);
		if(dir != null){
		    sqsFolderChooser.setCurrentDirectory(dir);
		}
		sqsFolderChooser.setDialogTitle(OPEN_SQSFOLDER_TITLE);
		sqsFolderChooser.addChoosableFileFilter(folderFilter);
	    return sqsFolderChooser;
	}
    
    static final Object[][] SUFFIX_ICON_MAP = new Object[][]{
            {".tiff", srcImageIcon},
            {".jpg", srcImageIcon},
            {".jpeg", srcImageIcon},
            {".gif", srcImageIcon},
            {".png", textImageIcon},
            {".sqs", sqsIcon},
            {".pdf", pdfIcon},
            {"-csv.txt", csvIcon}
        };
    
    public FileView createFileView() {
        return new SQSFileView();
    }

    class SQSFileView extends FileView {
        public Icon getIcon(File f) {
            String name = f.getName();
            if (f.isDirectory()) {
                return treeFolderIcon;
            } else {
                for (int i = 0; i < SUFFIX_ICON_MAP.length; i++) {
                    Object[] entry = SUFFIX_ICON_MAP[i];
                    String suffix = (String) entry[0];
                    if (name.endsWith(suffix)) {
                        return (Icon) entry[1];
                    }
                }
                return defaultFileIcon;

            }
        }
    }
}
