/*

 SQSSourceEditorToolBar.java
 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on 2004/07/31

 */
package net.sf.sqs_xml.editor.sqs.swing;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;

import javax.jnlp.BasicService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.metal.MetalIconFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;

import net.sf.sqs_xml.editor.base.swing.SourceEditorToolBar;
import net.sf.sqs_xml.swing.IconFactory;
import net.sf.sqs_xml.translator.logic.TranslatorException;
import net.sf.sqs_xml.util.AlbertBrowserLauncher;
import net.sf.sqs_xml.util.BrowserLauncher;
import net.sf.sqs_xml.util.JNLPBrowserLauncher;


/**
 * @author hiroya
 *
 */
public class SQSSourceEditorToolBar extends SourceEditorToolBar{
    public static final long serialVersionUID = 0;
    private SQSSourceEditorMediator mediator;
   
    JButton htmlExportButton;
    JButton previewExportButton;
    JButton pdfExportButton;
    
    JButton closeButton;
    final ExportFileLogic logic;
    
/*    
    static SQStoHTMLTranslator htmlTranslator = null;
    static SQStoPreviewTranslator previewTranslator = null;
    static SQStoPDFTranslator pdfTranslator = null;
  */
    
    public SQSSourceEditorToolBar(final SQSSourceEditorMediator mediator){
        this.mediator = mediator;
        this.logic = new ExportFileLogic(mediator);
        setPreferredSize(new Dimension(660, 24));
        
        this.htmlExportButton = new JButton("HTMLフォーム", IconFactory.create("formdoc.gif","HTML書き出し"));
        this.htmlExportButton.setPreferredSize(new Dimension(195, 20));
        
        this.previewExportButton = new JButton("HTMLで印刷原稿をプレビュー", IconFactory.create("preview.gif","HTML書き出し"));
        this.previewExportButton.setPreferredSize(new Dimension(220, 20));
        
        this.pdfExportButton = new JButton("PDFで印刷原稿をプレビュー", IconFactory.create("pdfdoc.gif", "PDF書き出し"));
        this.pdfExportButton.setPreferredSize(new Dimension(190, 20));

        this.closeButton = new JButton(MetalIconFactory.getInternalFrameCloseIcon(18));
        this.closeButton.setPreferredSize(new Dimension(19, 20));
        this.closeButton.setBorder(new EmptyBorder(0,0,0,0));
        
        htmlExportButton.setToolTipText("Webブラウザで回答するためのフォームを生成します");
        previewExportButton.setToolTipText("HTMLでレイアウトを確認します");
	    pdfExportButton.setToolTipText("PDF形式で印刷原稿を確認します");
	    closeButton.setToolTipText("このバッファを閉じます");
	    closeButton.addActionListener(new ActionListener(){
	        public void actionPerformed(ActionEvent ev){
	            mediator.getMenuBarMediator().close();
	        }
	    });
	    setupBrowserLauncher();
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());

        Box left = Box.createHorizontalBox();
        left.add(Box.createHorizontalStrut(7));
        left.add(htmlExportButton);
        left.add(Box.createHorizontalStrut(7));
        left.add(previewExportButton);
        left.add(Box.createHorizontalStrut(7));
	    left.add(pdfExportButton);

	    panel.add(left, BorderLayout.WEST);
	    panel.add(closeButton, BorderLayout.EAST);	    
	    add(panel);
	    setEnabled(false);
    }

    public void setupBrowserLauncher(){
        if(isBasicServiceEnabled()){
        	try{
        	    BasicService basicService = (BasicService)ServiceManager.lookup("javax.jnlp.BasicService");
        	    if(basicService.isWebBrowserSupported()){
        	        setupButtonActionListener(new JNLPBrowserLauncher(basicService));
        	    }else{
        	        setupButtonActionListener(new AlbertBrowserLauncher());
        	    }
        	}catch(UnavailableServiceException ignore){
        	    setupButtonActionListener(new AlbertBrowserLauncher());
        	}
        }else{
            setupButtonActionListener(new AlbertBrowserLauncher());
        }
    }
    
    public boolean isBasicServiceEnabled(){
        return true;
    }
    
    public void setEnabled(boolean enabled){
        htmlExportButton.setEnabled(enabled);
        previewExportButton.setEnabled(enabled);
        pdfExportButton.setEnabled(enabled);
        closeButton.setVisible(enabled);
    }
    
    private void setupButtonActionListener(final BrowserLauncher launcher) {
        htmlExportButton.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent ev){
                try {
                    logic.export(launcher, ExportFileLogic.HTML_MODE);
                } catch (IOException e) {
                    mediator.getMenuBarMediator().showError(e, "書き出しに失敗しました");
                } catch (TransformerFactoryConfigurationError e) {
                    e.printStackTrace();
                } catch (TranslatorException e) {
                    mediator.getMenuBarMediator().showError(e, "書き出しに失敗しました");
                }
            }
        });
        previewExportButton.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent ev){
                try {
                    logic.export(launcher, ExportFileLogic.HTML_PREVIEW_MODE);
                } catch (IOException e) {
                    mediator.getMenuBarMediator().showError(e, "書き出しに失敗しました");
                } catch (TransformerFactoryConfigurationError e) {
                    e.printStackTrace();
                } catch (TranslatorException e) {
                    mediator.getMenuBarMediator().showError(e, "書き出しに失敗しました");
                }
            }
        });
        pdfExportButton.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent ev){
                try {
                    logic.export(launcher, ExportFileLogic.PDF_MODE);
                } catch (IOException e) {
                    mediator.getMenuBarMediator().showError(e, "書き出しに失敗しました");
                } catch (TransformerFactoryConfigurationError e) {
                    e.printStackTrace();
                } catch (TranslatorException e) {
                    mediator.getMenuBarMediator().showError(e, "書き出しに失敗しました");
                }
            }
        });
    }
}
