/*

 ContentServlet.java
 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on 2004/10/17

 */
package net.sf.sqs_xml.httpd;

import java.io.IOException;
import java.net.URL;
import org.mortbay.jetty.servlet.Default;
import org.mortbay.util.Resource;
/**
 * @author hiroya
 *
 */
public class JarContentServlet extends Default {
    public static final long serialVersionUID = 0;
    protected Resource getResource(String pathInContext) throws IOException {
        URL url = getResourceURL(pathInContext);
        return Resource.newResource(url);
    }
    public static URL getResourceURL(String name) {
        if (name == null || name.length()==0){
            return null;
        }
        return JarContentServlet.class.getResource(name);
    }
}
