/*

 SQSHttpd.java
 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on 2004/10/17

 */
package net.sf.sqs_xml.httpd;


/**
 * @author hiroya
 *
 */
public class SourceEditorHttpd extends MicroHttpd{
    final static Integer port = new Integer(SQSHttpdFactory.prop.getString("sourceeditor.http.port"));
    static SourceEditorHttpd self;
    public SourceEditorHttpd(){
        super(port.intValue());
    }
    
    public static SourceEditorHttpd getSingleton(){
        if(self == null){
            synchronized(port){
                if(self == null){
                    self = new SourceEditorHttpd();
                    SQSHttpdFactory.setInitialHttpd(self);
                }
            }
        }
        return self;
    }
}
