/*

 ViewMatrixServlet.java
 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on 2004/11/02

 */
package net.sf.sqs_xml.httpd;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

import net.sf.sqs_xml.util.FileUtil;
import net.sf.sqs_xml.util.StringUtil;

/**
 * @author hiroya
 *
 */
public class ViewMatrixServlet extends HttpServlet {
    public static final long serialVersionUID = 0;
    public void service(HttpServletRequest request, HttpServletResponse response)throws ServletException, IOException{
        String resultDir = getResultDir(request);
        String srcFile = request.getParameter("src");
        srcFile = (srcFile == null)? "textarea.html":srcFile;
        MicroHttpd httpd = SQSHttpdFactory.getInitialHttpd();
        List matrix = readCSV(new File(resultDir), "MS932");
        OutputStream output = new BufferedOutputStream(response.getOutputStream());
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/html");
        //response.setHeader("Pragma", "no-cache");
        try{
        PrintWriter writer = FileUtil.createPrintWriter(response.getOutputStream(), "UTF-8");
        String parserClass = "org.apache.crimson.parser.XMLReaderImpl";
        XMLReader reader = XMLReaderFactory.createXMLReader(parserClass);
        //reader.setFeature("http://xml.org/sax/features/namespaces",true);
        FormFilter filter = new FormFilter(httpd, resultDir, MarkReaderHttpd.UPDATE_URI, srcFile, matrix);
        filter.setParent(reader);
        DataHandler handler = new DataHandler(writer);
        filter.setContentHandler(handler);
        reader.setErrorHandler(handler);
        InputSource file = new InputSource(new FileInputStream(new File(resultDir+File.separator+srcFile)));
        filter.parse(file);
        writer.close();
        output.close();
        }catch(SAXException ex){
            ex.printStackTrace();
        }
    }
    
    String getResultDir(HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        String resultDir = request.getParameter("dir");
        if(resultDir != null){
            session.setAttribute("dir", resultDir);
        }else{
            resultDir = (String)session.getAttribute("dir");
        }
        return resultDir;
    }

    List readCSV(File resultDir, String encoding) throws ServletException, IOException {        
        List ret = new ArrayList();
        File csvFile = getCSVFile(resultDir);
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(new FileInputStream(csvFile), encoding));
        String line = null;
        int columnLength = 0;
        for(int j=0; (line = reader.readLine()) != null; j++){
            if(j == 0){
                String[] args = line.split("\t");
                columnLength = args.length;
            }
            List current = new ArrayList();
            String[] args = line.split("\t");
            for(int i = 0; i < args.length; i++){
                String arg = args[i];
                current.add(StringUtil.unescape(arg));
            }
            for(int i = columnLength - args.length; 0 <= i; i--){
                current.add("");
            }
            ret.add(current);
        }
        reader.close();
        return ret;
    }

    File getCSVFile(File resultDir){
        return findFile(resultDir, "-csv.txt");        
    }

    File findFile(File resultDir, String suffix){
        List list = FileUtil.find(resultDir, suffix);        
        if(list.size() != 1){
            throw new RuntimeException("ERROR: folder="+ resultDir+", suffix="+suffix+",  found="+list.size()+" files.");
        }
        return (File)list.get(0);
    }
    
    PrintWriter getWriter(HttpServletResponse response, String encoding) throws IOException {
        return new PrintWriter(new OutputStreamWriter(new BufferedOutputStream(response.getOutputStream()), encoding));
    }

}
