/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package net.sf.sqs_xml.reader.model;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.w3c.dom.*;

/**
 * <b>FormElements</b> is generated from reader.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <define name="FormElements">
 *                <zeroOrMore>
 *                    <choice>
 *                         <element name="markarea" ns="http://sqs.cmr.sfc.keio.ac.jp/2004/reader">
 *                           <attribute name="ref" java:mapKey="true"><data type="string"/></attribute>
 *                             <ref name="MarkDensity"/>
 *                         </element>
 *                         <element name="textarea" ns="http://sqs.cmr.sfc.keio.ac.jp/2004/reader">
 *                           <attribute name="ref" java:mapKey="true"><data type="string"/></attribute>
 *                             <ref name="TextareaImage"/>
 *                         </element>                              
 *                 	</choice>
 *               </zeroOrMore>
 * </define>-->
 * <!-- for javadoc -->
 * <pre> &lt;define name="FormElements"&gt;
 *                &lt;zeroOrMore&gt;
 *                    &lt;choice&gt;
 *                         &lt;element name="markarea" ns="http://sqs.cmr.sfc.keio.ac.jp/2004/reader"&gt;
 *                           &lt;attribute name="ref" java:mapKey="true"&gt;&lt;data type="string"/&gt;&lt;/attribute&gt;
 *                             &lt;ref name="MarkDensity"/&gt;
 *                         &lt;/element&gt;
 *                         &lt;element name="textarea" ns="http://sqs.cmr.sfc.keio.ac.jp/2004/reader"&gt;
 *                           &lt;attribute name="ref" java:mapKey="true"&gt;&lt;data type="string"/&gt;&lt;/attribute&gt;
 *                             &lt;ref name="TextareaImage"/&gt;
 *                         &lt;/element&gt;                              
 *                 	&lt;/choice&gt;
 *               &lt;/zeroOrMore&gt;
 * &lt;/define&gt;</pre>
 *
 * @version reader.rng (Fri Aug 06 03:48:33 GMT+09:00 2004)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
public class FormElements implements java.io.Serializable, Cloneable, IRNSContainer, IRNode {
    public static final long serialVersionUID = 0;
    private RNSContext rNSContext_ = new RNSContext(this, "");
    // List<IFormElementsChoice>
    private java.util.List content_ = new java.util.ArrayList();
    private IRNode parentRNode_;

    /**
     * Creates a <code>FormElements</code>.
     *
     */
    public FormElements() {
    }

    /**
     * Creates a <code>FormElements</code>.
     *
     * @param source
     */
    public FormElements(FormElements source) {
        setup(source);
    }

    /**
     * Creates a <code>FormElements</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public FormElements(RStack stack) {
        setup(stack);
    }

    /**
     * Initializes the <code>FormElements</code> by the FormElements <code>source</code>.
     *
     * @param source
     */
    public void setup(FormElements source) {
        int size;
        this.content_.clear();
        size = source.content_.size();
        for (int i = 0;i < size;i++) {
            addContent((IFormElementsChoice)source.getContent(i).clone());
        }
    }

    /**
     * Initializes the <code>FormElements</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        Element element = stack.getContextElement();
        content_.clear();
        while (true) {
            if (FormElementsMarkarea.isMatch(stack)) {
                addContent(new FormElementsMarkarea(stack));
            } else if (FormElementsTextarea.isMatch(stack)) {
                addContent(new FormElementsTextarea(stack));
            } else {
                break;
            }
        }
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new FormElements((FormElements)this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc = parent.getOwnerDocument();
        Element element = (Element)parent;
        int size;
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IFormElementsChoice value = (IFormElementsChoice)this.content_.get(i);
            value.makeElement(element);
        }
    }

    /**
     * Gets the RNSContext property <b>RNSContext</b>.
     *
     * @return RNSContext
     */
    public RNSContext rGetRNSContext() {
        return (rNSContext_);
    }

    /**
     * Sets the RNSContext property <b>RNSContext</b>.
     *
     * @param rNSContext
     */
    public void rSetRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    /**
     * Gets the IFormElementsChoice property <b>content</b>.
     *
     * @return IFormElementsChoice[]
     */
    public IFormElementsChoice[] getContent() {
        IFormElementsChoice[] array = new IFormElementsChoice[content_.size()];
        return ((IFormElementsChoice[])content_.toArray(array));
    }

    /**
     * Sets the IFormElementsChoice property <b>content</b>.
     *
     * @param content
     */
    public void setContent(IFormElementsChoice[] content) {
        this.content_.clear();
        for (int i = 0;i < content.length;i++) {
            addContent(content[i]);
        }
        for (int i = 0;i < content.length;i++) {
            content[i].rSetParentRNode(this);
        }
    }

    /**
     * Sets the IFormElementsChoice property <b>content</b>.
     *
     * @param content
     */
    public void setContent(IFormElementsChoice content) {
        this.content_.clear();
        addContent(content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IFormElementsChoice property <b>content</b>.
     *
     * @param content
     */
    public void addContent(IFormElementsChoice content) {
        this.content_.add(content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IFormElementsChoice property <b>content</b>.
     *
     * @param content
     */
    public void addContent(IFormElementsChoice[] content) {
        for (int i = 0;i < content.length;i++) {
            addContent(content[i]);
        }
        for (int i = 0;i < content.length;i++) {
            content[i].rSetParentRNode(this);
        }
    }

    /**
     * Gets number of the IFormElementsChoice property <b>content</b>.
     *
     * @return int
     */
    public int sizeContent() {
        return (content_.size());
    }

    /**
     * Gets the IFormElementsChoice property <b>content</b> by index.
     *
     * @param index
     * @return IFormElementsChoice
     */
    public IFormElementsChoice getContent(int index) {
        return ((IFormElementsChoice)content_.get(index));
    }

    /**
     * Sets the IFormElementsChoice property <b>content</b> by index.
     *
     * @param index
     * @param content
     */
    public void setContent(int index, IFormElementsChoice content) {
        this.content_.set(index, content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IFormElementsChoice property <b>content</b> by index.
     *
     * @param index
     * @param content
     */
    public void addContent(int index, IFormElementsChoice content) {
        this.content_.add(index, content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Remove the IFormElementsChoice property <b>content</b> by index.
     *
     * @param index
     */
    public void removeContent(int index) {
        this.content_.remove(index);
    }

    /**
     * Remove the IFormElementsChoice property <b>content</b> by object.
     *
     * @param content
     */
    public void removeContent(IFormElementsChoice content) {
        this.content_.remove(content);
    }

    /**
     * Clear the IFormElementsChoice property <b>content</b>.
     *
     */
    public void clearContent() {
        this.content_.clear();
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IFormElementsChoice value = (IFormElementsChoice)this.content_.get(i);
            value.makeTextElement(buffer);
        }
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        String prefix = rNSContext_.getPrefixByUri("");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IFormElementsChoice value = (IFormElementsChoice)this.content_.get(i);
            value.makeTextElement(buffer);
        }
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IFormElementsChoice value = (IFormElementsChoice)this.content_.get(i);
            value.makeTextElement(buffer);
        }
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
        int size;
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IFormElementsChoice value = (IFormElementsChoice)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
        int size;
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IFormElementsChoice value = (IFormElementsChoice)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
        int size;
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IFormElementsChoice value = (IFormElementsChoice)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public IRNode rGetParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] rGetRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        classNodes.addAll(content_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>FormElements</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        return (isMatchHungry(stack.makeClone()));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>FormElements</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        RStack target = stack;
        boolean $match$ = false;
        Element element = stack.peekElement();
        Element child;
        while (true) {
            if (FormElementsMarkarea.isMatchHungry(target)) {
                $match$ = true;
            } else if (FormElementsTextarea.isMatchHungry(target)) {
                $match$ = true;
            } else {
                break;
            }
        }
        return ($match$);
    }
}
