/*
 * 
   ReceiverServlet.java

   Copyright 2004 SQS Development Team / Community Management Research Project.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
 */
package net.sf.sqs_xml.receiver;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.ServletException;

//import java.io.PrintWriter;
import java.io.IOException;
import java.util.Map;
import java.io.File;
import java.io.FileOutputStream;
import java.io.BufferedOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.text.SimpleDateFormat;

import net.sf.sqs_xml.util.StringUtil;

/**
 * ReceiverServlet
 */
public class ReceiverServlet extends HttpServlet{
    public static final long serialVersionUID = 0;
	public void doGet(HttpServletRequest request, HttpServletResponse response)throws ServletException, IOException{
		doPost(request, response);
	}
	
	public static final File DATA_LOG_FILE = new File("/var/tmp/sqs-log");		
	public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
	
	public void doPost(HttpServletRequest request, HttpServletResponse response)throws ServletException,IOException{
		Map parameterMap = request.getParameterMap();
		Object[] keyArray = parameterMap.keySet().toArray();
		java.util.Arrays.sort(keyArray);
		response.setContentType("text/plain; charset=UTF-8");

		synchronized(DATA_LOG_FILE){
			PrintWriter logWriter = new PrintWriter(new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(DATA_LOG_FILE, true)), "UTF-8"));
			if(DATA_LOG_FILE.length() == 0){
				printHeader(keyArray, logWriter);
			}
			printLine(parameterMap, keyArray, logWriter);
			logWriter.flush();
			logWriter.close();
		}
		
		PrintWriter writer = new PrintWriter(response.getWriter());
		writer.println("ご協力ありがとうございました．");
		writer.close();
		//response.sendRedirect("thankyou.html");
	}

	/**
	 * @param parameterMap
	 * @param keyArray
	 * @param logWriter
	 */
	private void printLine(Map parameterMap, Object[] keyArray, PrintWriter logWriter) {
		logWriter.print(DATE_FORMAT.format(new Date())+"\t");
		for(int i=0; i < keyArray.length; i++){
			String key = (String)keyArray[i];
			String[] values = (String[])parameterMap.get(key);
			String value = null;
			try{
				value = new String(values[0].getBytes("iso-8859-1"), "UTF-8");
			}catch(java.io.UnsupportedEncodingException ex){}
			logWriter.print("\t");
			logWriter.print(key);
			logWriter.print("=");
			logWriter.print(StringUtil.escape(value));
		}
		logWriter.println();
	}

	/**
	 * @param keyArray
	 * @param logWriter
	 */
	private void printHeader(Object[] keyArray, PrintWriter logWriter) {
		logWriter.print("*");
		for(int i=0; i < keyArray.length; i++){
			logWriter.print("\t");
			logWriter.print(keyArray[i]);
		}
		logWriter.println();
	}
}
