/*
 * 
   FileDropAcceptablePanel.java

   Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
 */
package net.sf.sqs_xml.swing;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DnDConstants;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;
import java.util.List;

import javax.swing.JPanel;


public class FileDropAcceptablePanel extends JPanel implements DropTargetListener{
    public static final long serialVersionUID = 0;
    File file = null;
	
	public File getFile(){
		return file;
	}
	
	public FileDropAcceptablePanel(){
		new DropTarget(this, 
				DnDConstants.ACTION_COPY_OR_MOVE, 
				this, true);
	}
	
	public void drop(DropTargetDropEvent ev) {
		try {
			if((ev.getDropAction() & DnDConstants.ACTION_COPY_OR_MOVE)!=0){
				ev.acceptDrop(DnDConstants.ACTION_COPY_OR_MOVE);
				Transferable transferable = ev.getTransferable();
				List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
				/*for(int i=0; i<list.size(); i++){
				 File file = (File) list.get(i);
				 this.setText(file.getAbsolutePath());
				 }*/
				file = (File)list.get(0);
				ev.dropComplete(true);
			}
			else {
				ev.rejectDrop();
			}
		}
		catch(IOException e) {
			e.printStackTrace();
		}
		catch(UnsupportedFlavorException e) {
			e.printStackTrace();
		}
	}
	public void dragEnter(DropTargetDragEvent e) {
		e.acceptDrag(DnDConstants.ACTION_COPY_OR_MOVE);
	}
	public void dragExit(DropTargetEvent e) { }
	public void dragOver(DropTargetDragEvent e) { }
	public void dropActionChanged(DropTargetDragEvent e) { }
}