/*
 * 
 * SQStoPDFTranslator.java
 * 
 * Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */
package net.sf.sqs_xml.translator.logic;

import java.io.InputStream;
import java.io.OutputStream;

import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.TransformerHandler;

import net.sf.sqs_xml.editor.sqs.swing.SQSSourceEditorMediator;
import net.sf.sqs_xml.httpd.SourceEditorHttpd;

import org.apache.fop.apps.Driver;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.Options;
import java.net.URL;


public class SQStoPDFTranslator extends AbstractTranslator{
	public static final String SQS2FO = prop.getString("sqs2fo_xsl_file");
	static final String USERCONFIG_URL = SQSSourceEditorMediator.BASEURI+"/userconfig.xml";
	public static void main(String args[]) throws Exception {
		main(args, "net.sf.sqs_xml.translator.logic.SQStoPDFTranslator <in.sqs> <out.pdf>", 
		        SQS2FO.split(" "), new SQStoPDFTranslator(),
				SourceEditorHttpd.getSingleton().getBase());
	}
	
	public SQStoPDFTranslator()throws TranslatorException{
		super();
	}
	
	public void init()throws TranslatorException{
		super.init();
		System.setProperty("java.awt.headless", "true");
		try{
			new Options(new URL(USERCONFIG_URL).openStream());
		}catch(java.io.IOException ex){
			throw new TranslatorException(ex);
		}catch(FOPException ex){
			throw new TranslatorException(ex);
		}
	}
	
	public void translate(InputStream inputStream, TranslatorResource resource, OutputStream outputStream, String baseURI)throws TranslatorException{
	    resource.setXsltFilenames(SQS2FO.split(" "));
	    super.translate(inputStream, resource, outputStream, baseURI);
	}
	
	public void execute(InputStream inputStream, TranslatorResource resource, OutputStream outputStream,
			TransformerHandler starterHandler, TransformerHandler terminatorHandler)throws TranslatorException{
		Driver driver = new Driver();
		//driver.setLogger(resource.getLogger());
		driver.setRenderer(Driver.RENDER_PDF);
		driver.setOutputStream(outputStream);
		terminatorHandler.setResult(new SAXResult(driver.getContentHandler()));
	}
	
	public String[] getParameters(String filename) {
		if (filename.equals("embed-counter.xsl")) {
			return new String[]{
			"xhtml.h-attribute..sqs.prefix", "問",
			"xhtml.h-attribute..sqs.suffix", ".",
			"xhtml.h-attribute..sqs.format", "1",
			"sqs.counter-attribute..sqs.prefix", "(",
			"sqs.counter-attribute..sqs.suffix", ")",
			"sqs.counter-attribute..sqs.format", "1"};
		}else if(filename.equals("pxformsConvert1.xsl")) {
			return new String[]{
			"xforms.hint-attribute..sqs.prefix","",
			"xforms.hint-attribute..sqs.suffix", "",
			"xforms.hint-attribute..sqs.display", "inline",
			"xforms.help-attribute..sqs.prefix","(",
			"xforms.help-attribute..sqs.suffix",")",
			"xforms.help-attribute..sqs.display","inline",
			"xforms.alart-attribute..sqs.prefix","*",
			"xforms.alart-attribute..sqs.suffix","",
			"xforms.alart-attribute..sqs.display","inline"};
		}else if(filename.equals("outline.xsl")){
			return new String[]{
		    "bookmark-root-label","調査票の構造",
		    "bookmark-section-label","問",			
		    "bookmark-question-label","設問",
		    "bookmark-itemset-label","選択肢"
			};
		}else if(filename.equals("pxformsToFO.xsl")){
			return new String[]{
			"example-blank-mark-label", " : 空白マークの例",
			"example-filled-mark-label", ": 正しい塗り潰しの例",
			"example-incomplete-mark-label", ": 不十分な塗り潰しの例",
			/*
			"example-filled-mark-label", ": 正しいぬりつぶしの例",
			"example-incomplete-mark-label", ": 不十分なぬりつぶしの例",
			 */
			"characters-prohibit-line-break",
			"。．、，’”）｝」』〕】〉》々〜…ーぁぃぅぇぉっゃゅょゎァィゥェォッャュョヮ)'"
			};
		}else{
			return null;
/* 
“‘（｛「『〔【〈《(￥＄
*/
		}
	}

}
