/*
 * 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */
package net.sf.sqs_xml.translator.servlet;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.sf.sqs_xml.translator.logic.SQStoHTMLTranslator;
import net.sf.sqs_xml.translator.logic.TranslatorException;
import net.sf.sqs_xml.translator.logic.TranslatorResource;

import org.apache.avalon.framework.logger.NullLogger;

public class SQStoHTMLServlet extends GenericTranslationServlet{
    public static final long serialVersionUID = 0;
	SQStoHTMLTranslator logic;
	
	public SQStoHTMLServlet()throws Exception{
		this.logic = new SQStoHTMLTranslator();
	}

	public void init(ServletConfig config) throws ServletException {
		super.init(config);
	}

	public void perform(HttpServletRequest req, HttpServletResponse res)throws ServletException,IOException{
		InputStream inputStream = (InputStream)req.getAttribute("fileInputStream"); 
		try{
			ByteArrayOutputStream  htmlOutputStream = new ByteArrayOutputStream();
			((SQStoHTMLTranslator)logic).translate(inputStream,  new TranslatorResource(new NullLogger()), htmlOutputStream, null);//TODO
			res.setContentType("text/html; charset=UTF8");
			res.setContentLength( htmlOutputStream.size());
			htmlOutputStream.writeTo(res.getOutputStream());
			htmlOutputStream.flush();
			htmlOutputStream.close();
			res.getOutputStream().flush();
			res.getOutputStream().close();
		} catch (TranslatorException e) {
			throw new ServletException(e);
		} catch (FileNotFoundException e) {
			throw new ServletException(e);
		}
	}
}
