/*
 * 
 * PDFMaker.java
 * 
 * Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */
package net.sf.sqs_xml.translator.swing;

import java.io.File;
import javax.swing.UIManager;
import javax.swing.SwingUtilities;

import net.sf.sqs_xml.editor.sqs.swing.SQSFileChooser;
import net.sf.sqs_xml.httpd.SourceEditorHttpd;
import net.sf.sqs_xml.swing.SwingUtil;
import net.sf.sqs_xml.translator.logic.SQStoPDFTranslator;
import net.sf.sqs_xml.translator.logic.Translator;

public class PDFMaker extends SQSFileTranslator {
    public static final long serialVersionUID = 0;
	static final String TITLE = "SQS PDF Maker";
	public static void main(String args[]) throws Exception {
	    try{
	        SourceEditorHttpd.getSingleton();
	    }catch(Error ignore){
	    }
		System.setProperty("swing.plaf.metal.controlFont","Monospaced-12");
		//UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
		SwingUtil.Factory factory = new SwingUtil.Factory() {
			public Object create() throws Exception {
				return new SQStoPDFTranslator();
			}
		};
		Translator translator = (SQStoPDFTranslator) SwingUtil.newInstanceWithWaitPromptFrame(factory, TITLE, "Initializing...");
		File src = null;
		if(0 < args.length){
		  src = new File(args[0]);
		  if(! src.canRead()){
		      src = null;
		  }
		}
		PDFMaker self = new PDFMaker(translator, src);
		SwingUtilities.updateComponentTreeUI(self);
	}

	public PDFMaker(Translator translator, File src) throws Exception {
		super(null, TITLE, translator,
			SQSFileChooser.createOpenSQSSourceChooser(src),
			"SQS Source File: ",
			SQSFileChooser.createSavePDFFileChooser(src),
			"PDF File: ");
		this.setSize(300, 160);
		this.setVisible(true);
		//setSelectedFile(src);
	}
	
}
