/*

 SQSFileTranslater.java
 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on 2004/08/21

 */
package net.sf.sqs_xml.translator.swing;

import javax.swing.Icon;

import net.sf.sqs_xml.editor.base.swing.SuffixBasedFileChooser;
import net.sf.sqs_xml.editor.sqs.swing.SQSFileChooser;
import net.sf.sqs_xml.swing.SuffixBasedFileFilter;
import net.sf.sqs_xml.translator.logic.Translator;


/**
 * @author hiroya
 *
 */
public class SQSFileTranslator extends FileTranslator{
    public static final long serialVersionUID = 0;
    /**
     * @param icon
     * @param title
     * @param translator
     * @param inputFileChooser
     * @param inputFileLabel
     * @param outputFileChooser
     * @param outputFileLabel
     * @throws Exception
     */
    public SQSFileTranslator(Icon icon, String title, Translator translator,
            SuffixBasedFileChooser inputFileChooser, String inputFileLabel,
            SuffixBasedFileChooser outputFileChooser, String outputFileLabel)
            throws Exception {
        super(icon, title, translator, inputFileChooser, inputFileLabel,
                outputFileChooser, outputFileLabel);
    }
    
	public SuffixBasedFileChooser createSuffixBasedFileChooser(SuffixBasedFileFilter filter){
	    return new SQSFileChooser(filter);
	}

}
