/*
 * 
 
 StringUtil.java
 
 Copyright 2004 KUBO Hiroya (hiroya@sfc.keio.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */
package net.sf.sqs_xml.util;

import java.util.List;

public class StringUtil {
	public static String chop(String src, String separator){
		int delim = -1;
		if(0 <= (delim = src.lastIndexOf(separator))){
			return src.substring(0, delim);
		}else{
			return src;
		}
	}

	public static String escapeHTML(String text) {
		return text
		.replaceAll("&", "&amp;")
		.replaceAll("<", "&lt;")
		.replaceAll(">", "&gt;")
		.replaceAll("\"", "&quot;");
	}

	public static String escape(String text) {
		return text
		.replaceAll("\\\\", "\\\\\\\\")
		.replaceAll("[\n\r]+", "\\\\n")
		.replaceAll("\t", "\\\\t")
		.replaceAll(",", "\\\\,");
	}
	
	public static String unescape(String text) {
		return text
		.replaceAll("\\\\\\\\", "\\\\")
		.replaceAll("\\\\r", "")
		.replaceAll("\\\\n", "\n")
		.replaceAll("\\\\t", "\t")
		.replaceAll("\\\\,", ",");
	}
	
	public static String replaceAll(String src, char from, char to){
		return replaceAll(new StringBuffer(), src, String.valueOf(from), String.valueOf(to)).toString();
	}

	public static String replaceAll(String src, String from, String to){
		return replaceAll(new StringBuffer(), src, from, to).toString();
	}

	public static StringBuffer replaceAll(StringBuffer buf, String src, String from, String to){
		int p = 0;
		if(0 <= (p = src.indexOf(from))){
			buf.append(src.substring(0, p));
			buf.append(to);
			replaceAll(buf, src.substring(p+from.length()), from, to);
		}else{
			buf.append(src);
		}
		return buf;
	}
	
	/*
	 * 	public static String[] split(String src){
		return split(src, " ");
	}

	public static String[] split(String src, String delim){
	    Lis
		java.util.StringTokenizer token = new java.util.StringTokenizer(src, delim);
		String ret[]  = new String[token.countTokens()] ;
		for(int i=0; token.hasMoreTokens(); i++){
			ret[i] = (String)token.nextToken();
		}
		return ret;
	}

	public static String[] split(String src, String delim){
		java.util.StringTokenizer token = new java.util.StringTokenizer(src, delim);
		String ret[]  = new String[token.countTokens()] ;
		for(int i=0; token.hasMoreTokens(); i++){
			ret[i] = (String)token.nextToken();
		}
		return ret;
	}
	
*/
    public static String join(List list , String delim){
        StringBuffer ret = new StringBuffer();
        for(int i=0; i<list.size(); i++){
            if(i != 0){
                ret.append(delim);
            }
            ret.append(list.get(i));
        }
        return ret.toString();
    }
    public static String join(Object[] array , String delim){
        StringBuffer ret = new StringBuffer();
        for(int i=0; i<array.length; i++){
            if(i != 0){
                ret.append(delim);
            }
            ret.append(array[i]);
        }
        return ret.toString();
    }
}
