<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2004 SQS Development Team / Community Management Research Project.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:template name="xsl-function-loop">
		<xsl:param name="times"/>
		<xsl:param name="value"/>
		<xsl:if test="$times &gt; 0">
			<xsl:copy-of select="$value"/>
			<xsl:call-template name="xsl-function-loop">
				<xsl:with-param name="times">
					<xsl:value-of select="$times - 1"/>
				</xsl:with-param>
				<xsl:with-param name="value">
					<xsl:value-of select="$value"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	<xsl:template name="default">
		<xsl:param name="default"/>
		<xsl:param name="value"/>
		<xsl:choose>
			<xsl:when test="string-length($value)=0">
				<xsl:value-of select="$default"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$value"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
