/*
 * 

 PersistentCacheAccessorf.java

 Copyright 2007 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */
package net.sqs2.cache;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;

import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;

public class PersistentCacheAccessor {

	private PersistentCacheManager cacheManager;
	private Ehcache cache;

	public PersistentCacheAccessor create(File dir1, File dir2, String name, String dirname) throws IOException{
		return new PersistentCacheAccessor(dir1, dir2, name, dirname);
	}

	protected PersistentCacheAccessor(File dir1, File dir2, String name, String dirname) throws IOException{
		this.cacheManager = PersistentCacheManager.getInstance(dir1, dir2, dirname);
		this.cache = this.cacheManager.getECache(name);
	}

	public PersistentCacheManager getCacheManager(){
		return this.cacheManager;
	}

	public void flush() {
		this.cache.flush();
	}

	public void close() {
		this.cacheManager.shutdown();
	}

	public void removeAll(){
		this.cache.removeAll();
	}

	protected Ehcache getEhcache(){	
		return this.cache;
	}

	public Serializable get(Serializable key){
		Element element = getEhcache().get(key);
		if(element == null){
			return null;
		}else{
			return element.getValue();
		}
	}
}