/*
 * 

 ImageTranslationFilter.java

 Copyright 2007 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */
package net.sqs2.image;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;

public class ImageTranslationFilter extends ImageTranslator {
	BufferedImage image;

	public ImageTranslationFilter(BufferedImage image, Point[] masterCorners, Point[] imageCorners) {
		super(masterCorners, imageCorners);
		this.image = image;
	}
	
	public int getRGB(final int x, final int y, Point2D p) {
    	Point2D _p = getPoint((float) x, (float) y, p);
    	return this.image.getRGB((int) _p.getX(), (int) _p.getY());
    }

	public int getRGB(final float x, final float y, Point2D p) {
    	Point2D _p = getPoint((float) x, (float) y, p);
    	try{
    		return this.image.getRGB((int) _p.getX(), (int) _p.getY());
    	}catch(ArrayIndexOutOfBoundsException ignore){
    		return 0;
    	}
    }
	
	public void flush(){
		this.image.flush();
	}

}
