package net.sqs2.image;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;

public class ImageTranslator {

	private Point[] masterCorners;
	private Point[] blockCenters;
	private Point[] corners;
	
	private float masterWidth;
	private float masterHeight;
	private float ox;
	private float oy;
	private float ax;
	private float ay;
	private float bx;
	private float by;
	private float cx;
	private float cy;
	private float dx;
	private float dy;
	
	public ImageTranslator() {
		super();
	}

	public ImageTranslator(Point[] masterCorners, Point[] imageGuideBlockCenters) {
		this.masterCorners = masterCorners;
		this.blockCenters = imageGuideBlockCenters;
		this.corners = new Point[4];
		parseMaster();
		setCorners();
		setABCD();
	}

	public Point[] getCorners() {
		return this.corners;
	}

	public Point[] getBlockCenters() {
		return this.blockCenters;
	}

	public Point[] getMasterCorners() {
		return this.masterCorners;
	}

	private void parseMaster() {
		this.masterWidth = (float) (this.masterCorners[1].getX() - this.masterCorners[0].getX());
		this.masterHeight = (float) (this.masterCorners[2].getY() - this.masterCorners[0].getY());
		this.ox = (float) this.masterCorners[0].getX();
		this.oy = (float) this.masterCorners[0].getY();
	}

	private void setCorners() {
		float cx = (float) (this.blockCenters[3].getX() - this.blockCenters[2].getX());
		float cy = (float) (this.blockCenters[3].getY() - this.blockCenters[2].getY());
		float s = (float) ((this.masterCorners[0].getX() - this.masterCorners[2].getX()) / this.masterWidth);
		this.corners[0] = this.blockCenters[0];
		this.corners[1] = this.blockCenters[1];
		this.corners[2] = new Point((int)(this.blockCenters[2].getX() + cx * s), (int)(this.blockCenters[2].getY() + cy * s));
		this.corners[3] = new Point((int)(this.blockCenters[3].getX() + cx * s), (int)(this.blockCenters[3].getY() + cy * s));
	}

	private void setABCD() {
		this.ax = (float) ((this.corners[1].getX() - this.corners[0].getX()));
		this.ay = (float) ((this.corners[1].getY() - this.corners[0].getY()));
		this.bx = (float) ((this.corners[2].getX() - this.corners[0].getX()));
		this.by = (float) ((this.corners[2].getY() - this.corners[0].getY()));
		this.cx = (float) ((this.corners[3].getX() - this.corners[2].getX()));
		this.cy = (float) ((this.corners[3].getY() - this.corners[2].getY()));
		this.dx = (float) ((this.corners[3].getX() - this.corners[1].getX()));
		this.dy = (float) ((this.corners[3].getY() - this.corners[1].getY()));
	}

	public Point2D getPoint(final float x, final float y, Point2D ret) {
		float s = ((x - this.ox) / this.masterWidth);
		float t = ((y - this.oy) / this.masterHeight);
		float aax = (float)this.corners[0].getX() + this.ax * s;
		float aay = (float)this.corners[0].getY() + this.ay * t;
		float bbx = (float)this.corners[0].getX() + this.bx * s;
		float bby = (float)this.corners[0].getY() + this.by * t;
		float acx = (float)this.corners[2].getX() + this.cx * s - aax;
		float acy = (float)this.corners[2].getY() + this.cy * t - aay;
		float bdx = (float)this.corners[1].getX() + this.dx * s - bbx;
		float bdy = (float)this.corners[1].getY() + this.dy * t - bby;

		if(acx == 0){
			ret.setLocation(aax, bby);
		}else{
			float q = (acx * (bby - aay) - acy * (bbx - aax)) / (acy * bdx - acx * bdy);
			float p = (bbx + bdx * q - aax) / acx;
			ret.setLocation(aax + acx * p, aay + acy * p);
		}
		
		return ret;
	}

	public Point2D getPoint(final int x, final int y) {
		return this.getPoint((float) x, (float) y, new Point2D.Float());
	}

	public void translateTo(Point2D[] translatedRectCorners, Rectangle rect) {
		translatedRectCorners[0] = getPoint(rect.x, rect.y, translatedRectCorners[0]);
		translatedRectCorners[1] = getPoint(rect.x + rect.width, rect.y, translatedRectCorners[1]);
		translatedRectCorners[2] = getPoint(rect.x, rect.y + rect.height, translatedRectCorners[2]);
		translatedRectCorners[3] = getPoint(rect.x + rect.width, rect.y + rect.height, translatedRectCorners[3]);
	}

	public Point2D[] translate(Rectangle rect) {
		Point2D[] translatedRectCorners = new Point2D[4];
		
		translatedRectCorners[0] = getPoint(rect.x, rect.y, new Point2D.Float());
		translatedRectCorners[1] = getPoint(rect.x + rect.width, rect.y, new Point2D.Float());
		translatedRectCorners[2] = getPoint(rect.x, rect.y + rect.height, new Point2D.Float());
		translatedRectCorners[3] = getPoint(rect.x + rect.width, rect.y + rect.height, new Point2D.Float());
		return translatedRectCorners;
	}

}