/*

 AbstractMulticastAdvertisingService.java

 Copyright 2007 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Created on 2007/01/11

 */
package net.sqs2.net;

import java.awt.Toolkit;
import java.io.IOException;
import java.net.DatagramPacket;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

import net.sqs2.lang.GroupThreadFactory;

public class AbstractMulticastAdvertisingService extends AbstractMulticastService{
	GroupThreadFactory groupThreadFactory;
	private int threadPriority;
	public AbstractMulticastAdvertisingService(MulticastNetworkConnection con, int threadPriority){
		super(con);
		this.threadPriority = threadPriority;
	}

	class DatagramSender implements Runnable{
		DatagramPacket packet;
		DatagramSender(DatagramPacket packet){
			this.packet = packet;
		}

		public void run(){
			try{
				if(false){
					Toolkit.getDefaultToolkit().beep();
				}
				AbstractMulticastAdvertisingService.this.con.getSocket().send(this.packet);
			}catch(IOException ignore){
			}
		}
	}

	public void advertise(DatagramPacket datagram, int delay){
		this.groupThreadFactory = new GroupThreadFactory("net.sqs2.net.AbstractMulticastAdvertisingService", this.threadPriority, true);  
		start(Executors.newScheduledThreadPool(1, this.groupThreadFactory).scheduleWithFixedDelay(new DatagramSender(datagram), 0, delay, TimeUnit.SECONDS));
	}

	public void shutdown() {
		super.shutdown();
		if(this.groupThreadFactory != null){
			this.groupThreadFactory.destroy();
		}
	}
}