/*

 AbstractMulticastDiscoveryService.java

 Copyright 2007 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Created on 2007/01/11

 */
package net.sqs2.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

import net.sqs2.lang.GroupThreadFactory;

public abstract class AbstractMulticastDiscoveryService extends AbstractMulticastService{
	protected int bufferLength;
	protected int priority;
	ExecutorService executorService;
	private GroupThreadFactory groupThreadFactory;

	public AbstractMulticastDiscoveryService(MulticastNetworkConnection con, 
			int bufferLegth,
			int priority){
		super(con);
		this.bufferLength = bufferLegth; 
		this.priority = priority;
	}

	public Future<?> discover(){
		this.groupThreadFactory = new GroupThreadFactory("net.sqs2.net.AbstractMulticastDiscoveryService", this.priority, true);
		this.executorService = Executors.newSingleThreadExecutor(this.groupThreadFactory);
		return this.executorService.submit(new DatagramReceiver());
	}

	class DatagramReceiver implements Runnable{
		public void run() {
			byte[] buf = new byte[AbstractMulticastDiscoveryService.this.bufferLength];
			MulticastSocket socket = AbstractMulticastDiscoveryService.this.con.getSocket();
			while (isRunning) {				
				try {
					DatagramPacket packet = new DatagramPacket(buf, buf.length);
					socket.receive(packet);
					processMessage(packet.getAddress(), buf);
				} catch(SocketTimeoutException e) {
					if(! isRunning){
						break;
					}
				} catch(IOException e) {
					shutdown();
					break;
				}
			}
		}
	}

	@Override
	public void stop(){
		isRunning = false;
		super.stop();
	}

	@Override
	public void shutdown(){
		isRunning = false;
		this.executorService.shutdown();
		super.shutdown();
		/*
		while(true){
			try{
				Thread.yield();
				try{
					Thread.sleep(1000);
				}catch(InterruptedException ignore){}
				this.groupThreadFactory.destroy();
				break;
			}catch(IllegalThreadStateException ignore){}
		}*/
	}

	public abstract void processMessage(InetAddress inetAddr, byte[] buf);
}