/*

 AbstractMulticastService.java

 Copyright 2007 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Created on 2007/01/11

 */

package net.sqs2.net;
/*

AbstractMuticastService.java

Copyright 2007 KUBO Hiroya (hiroya@cuc.ac.jp).

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Created on 2007/01/11

 */
import java.io.IOException;
import java.util.concurrent.Future;

public class AbstractMulticastService {
	protected MulticastNetworkConnection con;
	protected Future<?> future;
	protected boolean isRunning = true;

	public AbstractMulticastService(MulticastNetworkConnection con){
		this.con = con;
	}

	public void start(Future<?> future){
		this.isRunning = true;
		this.future = future;
	}

	public void stop() {
		this.isRunning = false;
		if(this.future != null){
			this.future.cancel(true);
		}
	}

	public void shutdown() {
		stop();
		try{
			this.con.close();
		}catch(IOException ignore){
			//ignore.printStackTrace();
		}
	}

}