package net.sqs2.net;

import java.io.IOException;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;

public class ClassURIResolver  implements URIResolver {
	
	public Source resolve(String href, String base) throws TransformerException {
		try{
			String urlString = null; 
			if(0 < href.indexOf(":")){
				urlString = href;
			}else if(0 < base.indexOf(":")){
				 urlString = base+href;
			}else{
				throw new RuntimeException("invalid url: "+base+" "+href);
			}
			URL url = new URL(urlString);
			ClassURLConnection connection = new ClassURLConnection(url); 
			return new StreamSource(connection.getInputStream(), urlString);
		}catch(IOException ex){
			throw new TransformerException(ex);			
		}
    }
}
