package net.sqs2.net;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public class ClassURLConnection extends URLConnection{
	
	private Class<?> clazz;
	
	public ClassURLConnection(URL url ){
		super(url);
	}

	@Override
	public String getContentType(){
		return guessContentTypeFromName(this.url.getPath());
	}

	@Override
	public synchronized InputStream getInputStream() throws IOException{
		if( ! this.connected ){
			connect();
		}
		String path = this.url.getPath();
		if( path.startsWith("/")){
			path = path.substring(1);
		}
		return this.clazz.getClassLoader().getResourceAsStream(path);
	}

	@Override
	public synchronized void connect() throws IOException{
		String className = this.url.getHost();
		try{
			this.clazz = Class.forName(className);
			this.connected = true;
		}catch( ClassNotFoundException ex ){
			throw new RuntimeException("Class not found: " + ex.toString());
		}
	}
}
