/*

 NetworkUtil.java

 Copyright 2007 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Created on 2007/01/11

 */
package net.sqs2.net;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.LinkedList;

public class NetworkUtil {

	static InetAddress localhost = null;
	//static String loopbackAdress4 = "127.0.0.1";
	static{
		try{
			localhost = InetAddress.getLocalHost();
		}catch(Exception ex){
			ex.printStackTrace();
		}
	}

	public static LinkedList<Inet4Address> getInet4AddressList() throws SocketException {
		LinkedList<Inet4Address> inet4AddressList = new LinkedList<Inet4Address>();
		for (Enumeration<NetworkInterface> enu = NetworkInterface.getNetworkInterfaces(); enu.hasMoreElements();) {
			NetworkInterface net = enu.nextElement();
			try{
				/*
				 JDK1.6 API
				if(! net.isUp() || net.isLoopback()){
					continue;
				}*/
			}catch(NoSuchMethodError ignore){
			}
			for (Enumeration<InetAddress> e = net.getInetAddresses(); e.hasMoreElements();) {
				InetAddress address = e.nextElement();
				if (! address.getHostAddress().equals("127.0.0.1") && address instanceof Inet4Address) {
					inet4AddressList.add((Inet4Address)address);
				}
			}
		}
		return inet4AddressList;
	}

	public static LinkedList<Inet6Address> getInet6AddressList() throws SocketException {
		LinkedList<Inet6Address> inet6AddressList = new LinkedList<Inet6Address>();
		for (Enumeration<NetworkInterface> enu = NetworkInterface.getNetworkInterfaces(); enu.hasMoreElements();) {
			NetworkInterface net = enu.nextElement();
			/*
			if(! net.isUp() || net.isLoopback()){
				continue;
			}
			 */
			for (Enumeration<InetAddress> e = net.getInetAddresses(); e.hasMoreElements();) {
				InetAddress address = e.nextElement();
				if (! address.getHostAddress().equals(NetworkUtil.localhost.getHostAddress()) && address instanceof Inet6Address) {
					inet6AddressList.add((Inet6Address)address);
				}
			}
		}
		return inet6AddressList;
	}

	public static Inet4Address getInet4Address() throws SocketException {
		LinkedList<Inet4Address> list = getInet4AddressList();
		if(list.isEmpty()){
			throw new SocketException("no avaliable address");
		}
		return list.getLast();
	}

	public static Inet6Address getInet6Address() throws SocketException {
		LinkedList<Inet6Address> list = getInet6AddressList();
		if(list.isEmpty()){
			throw new SocketException("no avaliable address");
		}
		return list.getLast();
	}

	public static String getInet4HostAddress() throws SocketException {
		return getInet4Address().getHostAddress();
	}

	public static String getInet6HostAddress() throws SocketException {
		return getInet6Address().getHostAddress();
	}

}