/*

 RMIMulticastAdvertisingService.java

 Copyright 2007 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Created on 2007/01/11

 */
package net.sqs2.net;

import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RMIRegistryMulticastAdvertisingService extends StringMulticastAdvertisingService{
	long key;
	int rmiPort;
	int interval;
	public RMIRegistryMulticastAdvertisingService(MulticastNetworkConnection con, long key, int threadPriority, int rmiPort, int interval)throws UnknownHostException,IOException{
		super(con, threadPriority);
		this.key = key;
		this.rmiPort = rmiPort;
		this.interval = interval;
	}

	public void export(Remote remote, String name){
		try{
			if(RMIRegistryService.export(remote, this.rmiPort, name) == -1){
				Logger.getLogger("net").log(Level.WARNING, "RMI registry disabled.");
			}else{
				advertise(RMIRegistryService.createURL(this.rmiPort, name)+"\t"+this.key, this.interval);
			}
		}catch(RemoteException ignore){
			ignore.printStackTrace();
		}catch(SocketException ignore){
			ignore.printStackTrace();
		}
	}

	public void unexport(String name){
		try{
			if(RMIRegistryService.unexport(this.rmiPort, name)){
				Logger.getLogger("net").log(Level.WARNING, "RMI registry disabled.");
			}
			stop();
		}catch(RemoteException ignore){
			ignore.printStackTrace();
		}catch(SocketException ignore){
			ignore.printStackTrace();
		}
	}

}
