/*

 RMIMuticastDiscoveryService.java

 Copyright 2007 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Created on 2007/01/11

 */
package net.sqs2.net;

import java.awt.Toolkit;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;


public abstract class RMIRegistryMulticastDiscoveryService extends StringMuticastDiscoveryService {

	public RMIRegistryMulticastDiscoveryService(MulticastNetworkConnection con,
			int bufferLength,
			int threadPriority)throws UnknownHostException,IOException {		
		super(con, bufferLength, threadPriority);
	}

	public void processMessage(InetAddress peerAddr, String message) {
		String[] messages = message.split("\t");
		String omrSessionServiceURL = messages[0]; 
		long key = Long.parseLong(messages[1]);
		try{
			if(! peerAddr.isLoopbackAddress() && ! peerAddr.equals(NetworkUtil.getInet4Address())){
				processMessage(key, omrSessionServiceURL);
			}
		}catch(SocketException ignore){
			ignore.printStackTrace();
		}
	}

	public abstract void processMessage(long key, String omrSessionServiceURL);

}