/*

 RMIRegistryService.java

 Copyright 2007 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Created on 2007/01/11

 */
package net.sqs2.net;

import java.net.SocketException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RMIRegistryService {
	/*
	private static void setSecurityManager() {
		System.setSecurityManager(new SecurityManager() {

            public void checkPermission(Permission perm) {
            }

            public void checkPermission(Permission perm, Object context) {
            }

            public void checkConnect(String host, int port) {
                if (! host.equals("127.0.0.1") && ! host.equals("localhost") ) {
                    throw new AccessControlException("not localhost:" + host);
                }
            }

            public void checkConnect(String host, int port, Object context) {
            }
        });
	}
	 */

	public static int export(Remote remoteService, int defaultRMIPort, String bindingName) throws RemoteException,SocketException {
		int rmiPort = defaultRMIPort;
		Registry registry = null;
		registry = LocateRegistry.getRegistry(defaultRMIPort);
		try{
			registry.bind(bindingName, remoteService);
		}catch(AlreadyBoundException ignore){
			return -1;
			/*
			if(OMRConstants.SINGLETON_SERVICE_ENABLED){
				//  do nothing
				// Remote remote = registry.lookup(bindingName);
				return -1;
			}else{
				try{
					return export(remoteService, defaultRMIPort+1, bindingName);
				}catch(Exception ignore2){
					throw new RuntimeException(ignore2);
				}
			}*/
		}catch(java.rmi.ConnectException ignore){
			// create new RMI storage, go ahead
			registry = LocateRegistry.createRegistry(defaultRMIPort);
			registry.rebind(bindingName, remoteService);
		}

		Logger.getLogger("net").log(Level.INFO, " Export: "+bindingName);

		return rmiPort;
	}

	public static boolean unexport(int defaultRMIPort, String bindingName) throws RemoteException,SocketException {
		Registry registry = null;
		registry = LocateRegistry.getRegistry(defaultRMIPort);
		try{
			registry.unbind(bindingName);
		}catch(NotBoundException ignore){
			return false;
		}
		String serviceURL = createURL(defaultRMIPort, bindingName);
		Logger.getLogger("net").log(Level.INFO, " UnExport: "+serviceURL);
		return true;
	}

	public static String createURL(int port, String bindingName) throws SocketException{
		return "rmi://" + NetworkUtil.getInet4HostAddress() + ":" + port + "/" +bindingName;
	}
}
