/*

 MidiPlayer.java

 Copyright 2007 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Created on 2007/01/11

 */
package net.sqs2.sound;

import javax.sound.midi.Instrument;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
//import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;

public class MidiPlayer{
	private MidiChannel channel = null;
	private Synthesizer synthesizer = null;
	//private Soundbank soundbank = null;

	public MidiPlayer(int instrument_id){
		try{
			this.synthesizer = MidiSystem.getSynthesizer();
			//soundbank = synthesizer.getDefaultSoundbank();
			this.synthesizer.open();

			Instrument[] instruments = this.synthesizer.getDefaultSoundbank().getInstruments();
			this.synthesizer.loadInstrument(instruments[instrument_id]);

			this.channel = this.synthesizer.getChannels()[0];
		}catch(Exception ex){
			ex.printStackTrace();
		}
	}


	public void noteOn(int noteNumber, int velocity){
		if(this.channel != null){
			this.channel.noteOn(noteNumber , velocity);
		}
	}


	public void noteOff(int noteNumber, int velocity){
		if(this.channel != null){
			this.channel.noteOff(noteNumber , velocity);
		}
	}


	public void close(){
		try{
			this.synthesizer.close();
		} catch(Exception e){
			if(this.channel != null){
				this.channel.allNotesOff();
			}
		}
	}
}
