package net.sqs2.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;

import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class HelpMenu extends JMenu {

	private static final long serialVersionUID = 0L;
	protected JFrame frame;

	public HelpMenu(JFrame jframe, final MessageDialogModel versionDocumentModel, final DocumentDialogModel licenseDocumentModel){
		super("Help");
		this.frame = jframe;
		//JMenu helpMenu = new JMenu("Help");
		setMnemonic(KeyEvent.VK_H);
		
		JMenuItem helpMenuItem = new JMenuItem("Help Menu");
		JMenuItem aboutMenuItem = new JMenuItem("About...");
		JMenuItem licenseMenuItem = new JMenuItem("license terms...");
		
		helpMenuItem.addActionListener(new HelpMenuActionListener());
		
		aboutMenuItem.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ev){
				new DocumentDialog(getFrame(), licenseDocumentModel).setVisible(true);
			}
		});

		licenseMenuItem.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent ev){
				JOptionPane.showMessageDialog(getFrame(), versionDocumentModel.messages);
			}
		});
		add(helpMenuItem);
		addSeparator();
		add(aboutMenuItem);
		add(licenseMenuItem);
	}

	protected JFrame getFrame() {
    	return this.frame;
    }
	
	static class HelpMenuActionListener implements ActionListener{
		public void actionPerformed(ActionEvent ev){
			// TODO: create config window
		}
	}

}