/*
 * 

 MultiPhaseProgressBarPanel.java

 Copyright 2007 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */
package net.sqs2.swing;

import java.awt.BorderLayout;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class MultiPhaseProgressBarPanel extends JPanel {

	private static final long serialVersionUID = 0L;
	JTabbedPane tabbedPane;

	public MultiPhaseProgressBarPanel(){
		this.tabbedPane = new JTabbedPane(JTabbedPane.LEFT, JTabbedPane.SCROLL_TAB_LAYOUT);
		setLayout(new BorderLayout());
		add(this.tabbedPane);
	}

	public void addPhaseComponent(String title, String message){
		this.tabbedPane.add(title, new ProgressBarPanel(title, message));
	}

	public static void main(String[] args){
		MultiPhaseProgressBarPanel p = new MultiPhaseProgressBarPanel();
		JFrame f = new JFrame();
		f.add(p);

		p.addPhaseComponent("hoge1", "HOGE1");
		p.addPhaseComponent("hoge2", "HOGE2");
		p.addPhaseComponent("hoge3", "HOGE3");
		p.addPhaseComponent("hoge4", "HOGE4");

		f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		f.setSize(640, 480);
		f.setVisible(true);
	}	

}
