/*
 * 

 XSLTranslator.java

 Copyright 2004-2007 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */
package net.sqs2.translator;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Map;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamSource;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;

import net.sqs2.translator.Translator;
import net.sqs2.xml.XMLUtil;

import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;
import org.xml.sax.SAXException;

public class XSLTranslator extends AbstractTranslator implements Translator{

	TransformerHandler[] tHandlers = null;
	String baseURI = null;
	String[] xsltFilenames = null;
	Map<String,Entry[]> xsltParamEntryArrayMap = null;

	public static void main(String[] args, String message, String[] xsltFilenames, XSLTranslator self)throws TranslatorException, IOException{
		if (args.length < 2) {
			//System.err.println(message);
			return;
		}
		final String inFile = args[0];
		final String outFile = args[1];
		self.translate(inFile, outFile);
	}

	public XSLTranslator()throws TranslatorException{
		System.setProperty("javax.xml.transform.TransformerFactory", 
		"org.apache.xalan.processor.TransformerFactoryImpl");
		System.setProperty("javax.xml.parsers.DocumentBuilderFactory",
		"org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
		System.setProperty("javax.xml.parsers.SAXParserFactory",
		"org.apache.xerces.jaxp.SAXParserFactoryImpl");		
	}

	public synchronized void initialize(String baseURI, String[] xsltFilenames, Map<String,Entry[]> xsltParamEntryArrayMap)throws TranslatorException{
		this.baseURI = baseURI;
		if(xsltFilenames == null){
			this.xsltFilenames = new String[]{}; 
		}else{	
			this.xsltFilenames = xsltFilenames; 	
		}
		if(xsltParamEntryArrayMap != null){
			this.xsltParamEntryArrayMap = xsltParamEntryArrayMap;
		}
	}

	private TransformerHandler[] createTransformerHandlers() throws TransformerFactoryConfigurationError, TransformerConfigurationException {
		SAXTransformerFactory factory = (SAXTransformerFactory)TransformerFactory.newInstance();
		TransformerHandler[] tHandlers = new TransformerHandler[this.xsltFilenames.length];
		for(int i = 0; i < this.xsltFilenames.length; i++){
			String xsltFilename = this.xsltFilenames[i];
			tHandlers[i] = factory.newTransformerHandler(createStreamSource(xsltFilename, this.baseURI));
			tHandlers[i].setSystemId(this.baseURI+xsltFilename);
			Entry[] xsltParamEntryArray = null;
			if(this.xsltParamEntryArrayMap != null && (xsltParamEntryArray = this.xsltParamEntryArrayMap.get(xsltFilename)) != null){
				setTransformerParameters(tHandlers[i], xsltParamEntryArray);
			}
			if(0 < i){
				tHandlers[i-1].setResult(new SAXResult(tHandlers[i]));
			}
		}
		return tHandlers;
	}

	/*
	private void setTransformerParameters(Entry[] xsltParams){
		for(int i = 0; i < this.xsltFilenames.length; i++){
			setTransformerParameters(this.tHandlers[i], xsltParams);
		}
	}
	*/

	private void setTransformerParameters(TransformerHandler tHandler, Entry[] xsltParams){
		Transformer transformer = tHandler.getTransformer();
		if(xsltParams == null){
			return;
		}
		for(Entry entry: xsltParams){
			transformer.setParameter(entry.getKey(), entry.getValue());
		}
	}

	public StreamSource createStreamSource(String href, String base){
		try{
			//URL baseURL = new URL(base);
			URL u = new URL(base+href);
			//Logger.getAnonymousLogger().info(u.toString());
			//System.err.println("href="+href);
			//System.err.println("base="+base);
			return new StreamSource(u.openStream(), u.toString());
		}catch(java.io.IOException ex){
			ex.printStackTrace();
			throw new RuntimeException(ex);  
		}
	}

	/**
	 * @param saxTFactory
	 * @param list
	 * @return
	 * @throws TransformerConfigurationException
	 */
	/*
    private Transformer createTransformer(SAXTransformerFactory factory)throws TransformerException{
        Transformer transformer = factory.newTransformer(); // identity transformer
        transformer.setParameter("versionParam", "2.0");
        return transformer;
    }
	 */

	/**
	 * get XSLT base URI.
	 * @return base URI in string.
	 */
	public String getBaseURI(){
		return this.baseURI;
	}

	/**
	 * get XSLT script filenames as "XSLT pipe line".
	 * @return XSLT script filenames.
	 */
	public String[] getXsltFilenames(){
		return this.xsltFilenames;
	}

	public void execute(InputStream inputStream, String systemId, OutputStream outputStream) throws TranslatorException {
		try {
			SAXResult result = XMLUtil.createSAXResult(outputStream);
			try{
				//Logger.getAnonymousLogger().info(StringUtil.join(this.xsltFilenames, ", "));
				this.tHandlers = createTransformerHandlers();
			}catch(TransformerException ex){
				ex.printStackTrace();
				throw new TranslatorException(ex);
			}

			if(this.tHandlers == null){
				throw new TranslatorException("XSLTranslator is not initilized.");
			}
			synchronized (this) {
				this.tHandlers[this.tHandlers.length-1].setResult(result);
				XMLReader reader = XMLReaderFactory.createXMLReader();
				reader.setContentHandler(this.tHandlers[0]);
				InputSource is = new InputSource(inputStream);
				is.setSystemId(systemId);
				//System.out.println(systemId);
				reader.parse(is);
			}
		} catch (SAXException ex) {
			ex.printStackTrace();
			throw new TranslatorException(ex);
		} catch (IOException ex) {
			ex.printStackTrace();
			throw new TranslatorException(ex);
		} catch (Exception ex) {
			ex.printStackTrace();
			throw new TranslatorException(ex);
		}
	}
}
