/*

 FileResource.java

 Copyright 2007 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Created on 2007/01/11

 */
package net.sqs2.util;

import java.io.Serializable;

public class FileResource implements Comparable<FileResource>, Serializable{
	private static final long serialVersionUID = 1L;

	private String path;

	private long lastModified;

	public FileResource(){
	}

	public FileResource(String path, long lastModified){
		this.path = path;
		this.lastModified = lastModified;
	}

	public String toString(){
		return this.path+"@"+this.lastModified;
	}

	public String getPath(){
		return this.path;
	}

	public long getLastModified(){
		return this.lastModified;
	}

	public boolean equals(Object o){
		if(o == this){
			return true;
		}
		try{
			if(o == null){
				return false;
			}
			FileResource u = (FileResource)o;
			return u.getLastModified() == this.lastModified && u.getPath().equals(this.path);
		}catch(ClassCastException ex){
			return false;
		}
	}

	public int compareTo(FileResource o){
		try{
			int diff = 0;
			if((diff = this.path.compareTo(o.getPath())) != 0){
				return diff;
			}
			if((diff = (int)(this.lastModified - o.lastModified)) != 0){
				return diff;
			}
		}catch(ClassCastException ignore){}
		return 1;
	}

	public int hashCode() {
		if(this.path == null){
			return 0;
		}else{
			return (int)this.lastModified % this.path.hashCode();
		}
	}
}
