/*

 Resource.java

 Copyright 2004-2007 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Created on 2005/11/07

 */
package net.sqs2.util;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class Resource {

	private static Map<ResourceKey, ResourceBundle> map = new HashMap<ResourceKey, ResourceBundle>(); 
	ResourceKey resourceKey = null;
	ResourceBundle prop = null;

	private static class ResourceKey{
		String name;
		Locale locale;
		public ResourceKey(String name, Locale locale){
			this.name = name;
			this.locale = locale;
		}
		
		@Override
		public boolean equals(Object obj){
			if (obj instanceof ResourceKey) {
				ResourceKey o = (ResourceKey)obj; 
				if(o.name.equals(name) && o.locale.equals(locale)){
					return true;
				}
			}
			return false;
		}
		
		@Override
		public int hashCode(){
			return name.hashCode() ^ locale.hashCode();
		}
	}

	/**
	 * set resource name. you must call this method before calling Resource.get.
	 * @param name
	 */
	public Resource(String resourceName){
		this(resourceName, Locale.getDefault());
	}

	/**
	 * set resource name. you must call this method before calling Resource.get.
	 * @param name
	 * @param locale
	 */
	public Resource(String resourceName, Locale locale){
		this.resourceKey = new ResourceKey(resourceName, locale);
		if(map.containsKey(resourceKey)){
			this.prop = map.get(resourceKey);
		}else{
			this.prop = ResourceBundle.getBundle(resourceName, locale);
			map.put(resourceKey, this.prop);
		}
	}

	/**
	 * get property resource bundle string. 
	 * @param key
	 * @return resource value
	 */
	public String getString(String key){
		if(prop != null){
			return prop.getString(key);
		}else{
			throw new RuntimeException("Resource.setResourceName(name) has not been called.");
		}
	}

	public int getInt(String key) {
		return Integer.parseInt(getString(key));
	}

	public double getDouble(String key) {
		return Double.parseDouble(getString(key));
	}

	public float getFloat(String key) {
		return Float.parseFloat(getString(key));
	}

}
