using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Reflection;
using System.Text;
using System.Text.RegularExpressions;
using System.Windows.Forms;
using Ruby;
using StarEngine.Core;

namespace StarEngine.Ruby
{
    using VALUE = System.Int32;

    /// <summary>
    /// Ruby ̃C^v^JvZ܂B
    /// </summary>
    public partial class RubyInterpreter : IDisposable
    {
        public static RubyInterpreter Create(IGameEnvironment env)
        {
            if (Instance != null)
                throw new InvalidOperationException("RubyInterpreter IuWFNg͓ɓł܂B");
            
            return Instance = new RubyInterpreter(env);
        }
        private static RubyInterpreter Instance;

        private RubyGame Game;
        private IGameEnvironment GameEnvironment;
        private ConsoleForm ConsoleForm;

        private RubyInterpreter(IGameEnvironment gameEnvironment)
        {
            this.Game = new RubyGame(this);
            this.GameEnvironment = gameEnvironment;
            this.ConsoleForm = new ConsoleForm();

            RUBY.ruby_init();
            RUBY.rb_eval_string("$KCODE = 'u'");

            RUBY.rb_define_singleton_method(RUBY.rb_eval_string("STDOUT"), "write", this.rb_stdout_write);
            RUBY.rb_define_singleton_method(RUBY.rb_eval_string("STDERR"), "write", this.rb_stdout_write);

            RUBY.rb_define_module_function(SERubyConsts.mStarEngine, "activate_console", this.mStarEngine_activate_console);

            this.EvaluateInnerFile("star_engine.rb");

            this.InitializeAudioModule();
            this.InitializeCSharpCachedObjectModule();
            this.InitializeGameModule();
            this.InitializeInputModule();
            this.InitializeScreenModule();

            this.InitializeFontClass();
            this.InitializeTextureClass();
        }

        private VALUE rb_stdout_write(VALUE self, VALUE str)
        {
            if (!this.ConsoleForm.Visible)
                this.ConsoleForm.Show();
            this.ConsoleForm.Write(RUBY.StringValuePtr(str));
            return RUBY.Qnil;
        }

        private VALUE mStarEngine_activate_console(VALUE self)
        {
            this.ConsoleForm.Show();
            this.ConsoleForm.Activate();
            Application.Run(this.ConsoleForm);
            return RUBY.Qnil;
        }

        /// <summary>
        /// [hpXǉ܂B
        /// </summary>
        /// <param name="path">[hpXB</param>
        public void AddLoadPath(string path)
        {
            path = path.Replace('\\', '/');
            // UTF-8 ƁA܂fBNgȂ (\)
            RUBY.rb_eval_string(Encoding.Default.GetBytes("$LOAD_PATH << '" + path + "'"));
        }

        public bool IsDisposed
        {
            get { return this.isDisposed; }
            private set { this.isDisposed = value; }
        }
        private bool isDisposed = false;

        public void Dispose()
        {
            this.Dispose(true);
            GC.SuppressFinalize(this);
        }

        ~RubyInterpreter()
        {
            this.Dispose(false);
        }

        private void Dispose(bool isDisposing)
        {
            if (!this.IsDisposed)
            {
                this.IsDisposed = true;
                if (isDisposing)
                {
                    this.Cache.Clear();
                    this.ConsoleForm.Dispose();
                }
            }
        }

        /// <summary>
        /// XNvg]܂B
        /// </summary>
        /// <param name="bytes">Ruby XNvgB</param>
        public void Evaluate(byte[] bytes)
        {
            int state = 0;
            RUBY.rb_eval_string_protect(bytes, ref state);
            if (state != 0)
                throw new RubyInterpreterException(this.Error + "\n" + this.ErrorBacktrace);
        }

        /// <summary>
        /// XNvg]܂B
        /// </summary>
        /// <param name="script">Ruby XNvg̕B</param>
        public void Evaluate(string script)
        {
            this.Evaluate(RUBY.Encoding.GetBytes(script));
        }

        private void EvaluateInnerFile(string fileName)
        {
            Assembly asm = Assembly.GetExecutingAssembly();
            string scriptPrefix = asm.GetName().Name + ".Scripts.star_engine.";
            byte[] bytes;
            using (Stream stream = asm.GetManifestResourceStream(scriptPrefix + fileName))
            {
                bytes = new byte[stream.Length];
                stream.Read(bytes, 0, bytes.Length);
            }
            this.Evaluate(bytes);
        }

        /// <summary>
        /// ݔĂG[擾܂B
        /// </summary>
        private string Error
        {
            get
            {
                return RUBY.StringValuePtr(RUBY.rb_eval_string("$!.to_s"));
            }
        }

        /// <summary>
        /// ݔĂG[̃obNg[X擾܂B
        /// </summary>
        private string ErrorBacktrace
        {
            get
            {
                return RUBY.StringValuePtr(RUBY.rb_eval_string("$!.backtrace.join(\"\\n\")"));
            }
        }

        private Dictionary<int, object> Cache = new Dictionary<int, object>();

        /// <summary>
        /// Ruby IuWFNg C# IuWFNgƂ֘At܂B
        /// </summary>
        /// <param name="rbObject">Ruby IuWFNgB</param>
        /// <param name="csObject">C# IuWFNgB</param>
        internal void AddCachedObject(VALUE rbObject, object csObject)
        {
            this.Cache.Add(RUBY.GetID(rbObject), csObject);
        }

        /// <summary>
        /// Ruby IuWFNgɊ֘Atꂽ C# IuWFNg擾܂B
        /// </summary>
        /// <typeparam name="T">oľ^B</typeparam>
        /// <param name="rbObject">Ruby IuWFNgB</param>
        /// <returns>C# IuWFNgB</returns>
        internal T GetCachedObject<T>(VALUE rbObject)
        {
            int key = RUBY.GetID(rbObject);
            object obj;
            if (this.Cache.TryGetValue(key, out obj))
            {
                return (T)obj;
            }
            else
            {
                string message = string.Format("C# object was not found: {0}", RUBY.StringValuePtr(RUBY.Send(rbObject, "inspect")));
                RUBY.rb_raise(SERubyConsts.ForName("StarEngineError"), message);
                return default(T);
            }
        }

        internal bool ContainsCachedObject(VALUE rbObject)
        {
            return this.Cache.ContainsKey(RUBY.GetID(rbObject));
        }

        /// <summary>
        /// Ruby IuWFNg C# IuWFNgƂ̊֘A폜܂B
        /// </summary>
        /// <param name="rbObject">Ruby IuWFNg ID (C#  int)B</param>
        internal void RemoveCachedObject(int id)
        {
            this.Cache.Remove(id);
        }
    }
}
