using System;
using System.Collections.Generic;
using System.Drawing;
using System.Text;
using StarEngine.Core;

namespace StarEngine.Sdl
{
    internal sealed class TextureFactory : ITextureFactory
    {
        internal static TextureFactory Instance
        {
            get { return instance; }
        }
        private static TextureFactory instance = new TextureFactory();

        private TextureFactory()
        {
        }

        public ITexture Create(Size size)
        {
            return new Texture(size);
        }

        public ITexture Load(string path)
        {
            return new Texture(path);
        }
    }
}
