using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;
using StarEngine;
using StarEngine.Sdl;

namespace StarEngine.Tests.Sdl
{
    [TestFixture]
    public class InputTest
    {
        [Test]
        public void TestIsPressed()
        {
            Assert.IsFalse(Input.IsPressed(0, -1, -1, 0));
            Assert.IsTrue(Input.IsPressed(1, -1, -1, 0));
            Assert.IsTrue(Input.IsPressed(2, -1, -1, 0));
            Assert.IsTrue(Input.IsPressed(3, -1, -1, 0));
            Assert.IsTrue(Input.IsPressed(4, -1, -1, 0));
            Assert.IsTrue(Input.IsPressed(5, -1, -1, 0));
            Assert.IsTrue(Input.IsPressed(100, -1, -1, 0));

            Assert.IsFalse(Input.IsPressed(0, 0, -1, 0));
            Assert.IsFalse(Input.IsPressed(1, 0, -1, 0));
            Assert.IsFalse(Input.IsPressed(2, 0, -1, 0));
            Assert.IsFalse(Input.IsPressed(3, 0, -1, 0));
            Assert.IsFalse(Input.IsPressed(4, 0, -1, 0));
            Assert.IsFalse(Input.IsPressed(5, 0, -1, 0));
            Assert.IsFalse(Input.IsPressed(100, 0, -1, 0));

            Assert.IsFalse(Input.IsPressed(0, 1, -1, 0));
            Assert.IsTrue(Input.IsPressed(1, 1, -1, 0));
            Assert.IsFalse(Input.IsPressed(2, 1, -1, 0));
            Assert.IsFalse(Input.IsPressed(3, 1, -1, 0));
            Assert.IsFalse(Input.IsPressed(4, 1, -1, 0));
            Assert.IsFalse(Input.IsPressed(5, 1, -1, 0));
            Assert.IsFalse(Input.IsPressed(100, 1, -1, 0));

            Assert.IsFalse(Input.IsPressed(0, 3, -1, 0));
            Assert.IsTrue(Input.IsPressed(1, 3, -1, 0));
            Assert.IsTrue(Input.IsPressed(2, 3, -1, 0));
            Assert.IsTrue(Input.IsPressed(3, 3, -1, 0));
            Assert.IsFalse(Input.IsPressed(4, 3, -1, 0));
            Assert.IsFalse(Input.IsPressed(5, 3, -1, 0));
            Assert.IsFalse(Input.IsPressed(100, 3, -1, 0));
        }

        [Test]
        public void TestIsPressedWithDelay()
        {
            Assert.IsFalse(Input.IsPressed(0, -1, 3, 0));
            Assert.IsTrue(Input.IsPressed(1, -1, 3, 0));
            Assert.IsTrue(Input.IsPressed(2, -1, 3, 0));
            Assert.IsTrue(Input.IsPressed(3, -1, 3, 0));
            Assert.IsTrue(Input.IsPressed(4, -1, 3, 0));
            Assert.IsTrue(Input.IsPressed(5, -1, 3, 0));
            Assert.IsTrue(Input.IsPressed(100, -1, 3, 0));

            Assert.IsFalse(Input.IsPressed(0, 0, 3, 0));
            Assert.IsFalse(Input.IsPressed(1, 0, 3, 0));
            Assert.IsFalse(Input.IsPressed(2, 0, 3, 0));
            Assert.IsFalse(Input.IsPressed(3, 0, 3, 0));
            Assert.IsFalse(Input.IsPressed(4, 0, 3, 0));
            Assert.IsFalse(Input.IsPressed(5, 0, 3, 0));
            Assert.IsFalse(Input.IsPressed(100, 0, 3, 0));

            Assert.IsFalse(Input.IsPressed(0, 1, 3, 0));
            Assert.IsTrue(Input.IsPressed(1, 1, 3, 0));
            Assert.IsFalse(Input.IsPressed(2, 1, 3, 0));
            Assert.IsFalse(Input.IsPressed(3, 1, 3, 0));
            Assert.IsFalse(Input.IsPressed(4, 1, 3, 0));
            Assert.IsTrue(Input.IsPressed(5, 1, 3, 0));
            Assert.IsTrue(Input.IsPressed(6, 1, 3, 0));
            Assert.IsTrue(Input.IsPressed(7, 1, 3, 0));
            Assert.IsTrue(Input.IsPressed(8, 1, 3, 0));
            Assert.IsTrue(Input.IsPressed(100, 1, 3, 0));

            Assert.IsFalse(Input.IsPressed(0, 3, 3, 0));
            Assert.IsTrue(Input.IsPressed(1, 3, 3, 0));
            Assert.IsTrue(Input.IsPressed(2, 3, 3, 0));
            Assert.IsTrue(Input.IsPressed(3, 3, 3, 0));
            Assert.IsFalse(Input.IsPressed(4, 3, 3, 0));
            Assert.IsFalse(Input.IsPressed(5, 3, 3, 0));
            Assert.IsFalse(Input.IsPressed(6, 3, 3, 0));
            Assert.IsTrue(Input.IsPressed(7, 3, 3, 0));
            Assert.IsTrue(Input.IsPressed(8, 3, 3, 0));
            Assert.IsTrue(Input.IsPressed(100, 3, 3, 0));
        }

        [Test]
        public void TestIsPressedWithDelayAndInterval()
        {
            Assert.IsFalse(Input.IsPressed(0, -1, 3, 1));
            Assert.IsTrue(Input.IsPressed(1, -1, 3, 1));
            Assert.IsTrue(Input.IsPressed(2, -1, 3, 1));
            Assert.IsTrue(Input.IsPressed(3, -1, 3, 1));
            Assert.IsTrue(Input.IsPressed(4, -1, 3, 1));
            Assert.IsTrue(Input.IsPressed(5, -1, 3, 1));
            Assert.IsTrue(Input.IsPressed(100, -1, 3, 1));

            Assert.IsFalse(Input.IsPressed(0, 0, 3, 1));
            Assert.IsFalse(Input.IsPressed(1, 0, 3, 1));
            Assert.IsFalse(Input.IsPressed(2, 0, 3, 1));
            Assert.IsFalse(Input.IsPressed(3, 0, 3, 1));
            Assert.IsFalse(Input.IsPressed(4, 0, 3, 1));
            Assert.IsFalse(Input.IsPressed(5, 0, 3, 1));
            Assert.IsFalse(Input.IsPressed(100, 0, 3, 1));

            Assert.IsFalse(Input.IsPressed(0, 1, 3, 1));
            Assert.IsTrue(Input.IsPressed(1, 1, 3, 1));
            Assert.IsFalse(Input.IsPressed(2, 1, 3, 1));
            Assert.IsFalse(Input.IsPressed(3, 1, 3, 1));
            Assert.IsFalse(Input.IsPressed(4, 1, 3, 1));
            Assert.IsTrue(Input.IsPressed(5, 1, 3, 1));
            Assert.IsFalse(Input.IsPressed(6, 1, 3, 1));
            Assert.IsTrue(Input.IsPressed(7, 1, 3, 1));
            Assert.IsFalse(Input.IsPressed(8, 1, 3, 1));
            Assert.IsTrue(Input.IsPressed(9, 1, 3, 1));
            Assert.IsFalse(Input.IsPressed(10, 1, 3, 1));
            Assert.IsTrue(Input.IsPressed(11, 1, 3, 1));
            Assert.IsFalse(Input.IsPressed(12, 1, 3, 1));
            Assert.IsFalse(Input.IsPressed(100, 1, 3, 1));

            Assert.IsFalse(Input.IsPressed(0, 3, 3, 1));
            Assert.IsTrue(Input.IsPressed(1, 3, 3, 1));
            Assert.IsTrue(Input.IsPressed(2, 3, 3, 1));
            Assert.IsTrue(Input.IsPressed(3, 3, 3, 1));
            Assert.IsFalse(Input.IsPressed(4, 3, 3, 1));
            Assert.IsFalse(Input.IsPressed(5, 3, 3, 1));
            Assert.IsFalse(Input.IsPressed(6, 3, 3, 1));
            Assert.IsTrue(Input.IsPressed(7, 3, 3, 1));
            Assert.IsFalse(Input.IsPressed(8, 3, 3, 1));
            Assert.IsTrue(Input.IsPressed(9, 3, 3, 1));
            Assert.IsFalse(Input.IsPressed(10, 3, 3, 1));
            Assert.IsTrue(Input.IsPressed(11, 3, 3, 1));
            Assert.IsFalse(Input.IsPressed(12, 3, 3, 1));
            Assert.IsFalse(Input.IsPressed(100, 3, 3, 1));
        }

        [Test]
        public void TestIsPressedWithDelayAndInterval2()
        {
            Assert.IsFalse(Input.IsPressed(0, -1, 3, 2));
            Assert.IsTrue(Input.IsPressed(1, -1, 3, 2));
            Assert.IsTrue(Input.IsPressed(2, -1, 3, 2));
            Assert.IsTrue(Input.IsPressed(3, -1, 3, 2));
            Assert.IsTrue(Input.IsPressed(4, -1, 3, 2));
            Assert.IsTrue(Input.IsPressed(5, -1, 3, 2));
            Assert.IsTrue(Input.IsPressed(100, -1, 3, 2));

            Assert.IsFalse(Input.IsPressed(0, 0, 3, 2));
            Assert.IsFalse(Input.IsPressed(1, 0, 3, 2));
            Assert.IsFalse(Input.IsPressed(2, 0, 3, 2));
            Assert.IsFalse(Input.IsPressed(3, 0, 3, 2));
            Assert.IsFalse(Input.IsPressed(4, 0, 3, 2));
            Assert.IsFalse(Input.IsPressed(5, 0, 3, 2));
            Assert.IsFalse(Input.IsPressed(100, 0, 3, 2));

            Assert.IsFalse(Input.IsPressed(0, 1, 3, 2));
            Assert.IsTrue(Input.IsPressed(1, 1, 3, 2));
            Assert.IsFalse(Input.IsPressed(2, 1, 3, 2));
            Assert.IsFalse(Input.IsPressed(3, 1, 3, 2));
            Assert.IsFalse(Input.IsPressed(4, 1, 3, 2));
            Assert.IsTrue(Input.IsPressed(5, 1, 3, 2));
            Assert.IsFalse(Input.IsPressed(6, 1, 3, 2));
            Assert.IsFalse(Input.IsPressed(7, 1, 3, 2));
            Assert.IsTrue(Input.IsPressed(8, 1, 3, 2));
            Assert.IsFalse(Input.IsPressed(9, 1, 3, 2));
            Assert.IsFalse(Input.IsPressed(10, 1, 3, 2));
            Assert.IsTrue(Input.IsPressed(11, 1, 3, 2));
            Assert.IsFalse(Input.IsPressed(12, 1, 3, 2));
            Assert.IsFalse(Input.IsPressed(100, 1, 3, 2));

            Assert.IsFalse(Input.IsPressed(0, 3, 3, 2));
            Assert.IsTrue(Input.IsPressed(1, 3, 3, 2));
            Assert.IsTrue(Input.IsPressed(2, 3, 3, 2));
            Assert.IsTrue(Input.IsPressed(3, 3, 3, 2));
            Assert.IsFalse(Input.IsPressed(4, 3, 3, 2));
            Assert.IsFalse(Input.IsPressed(5, 3, 3, 2));
            Assert.IsFalse(Input.IsPressed(6, 3, 3, 2));
            Assert.IsTrue(Input.IsPressed(7, 3, 3, 2));
            Assert.IsFalse(Input.IsPressed(8, 3, 3, 2));
            Assert.IsFalse(Input.IsPressed(9, 3, 3, 2));
            Assert.IsTrue(Input.IsPressed(10, 3, 3, 2));
            Assert.IsFalse(Input.IsPressed(11, 3, 3, 2));
            Assert.IsFalse(Input.IsPressed(12, 3, 3, 2));
            Assert.IsTrue(Input.IsPressed(100, 3, 3, 2));
        }
    }
}
