/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.ui.window;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.table.DefaultTableModel;
import net.argius.logging.Logger;
import net.argius.logging.LoggerFactory;
import net.argius.stew.Iteration;
import net.argius.stew.ui.window.ValueTransporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ResultSetTableModel
extends DefaultTableModel {
    private static final Logger log = LoggerFactory.getLogger(ResultSetTableModel.class);
    private static final long serialVersionUID = -8861356207097438822L;
    private static final String PTN1 = "^.*\\s*SELECT\\s*.+\\s*FROM\\s*([^\\s]+)";
    private final int[] types;
    private final String commandString;
    private final Set<Integer> unlinkedRows;
    private Connection conn;
    private Object tableName;
    private String[] primaryKeys;
    private boolean updatable;

    ResultSetTableModel(ResultSet resultSet, Object[] objectArray, String string) throws SQLException {
        super(0, objectArray.length);
        int n;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n2 = this.getColumnCount();
        int[] nArray = new int[n2];
        for (n = 0; n < n2; ++n) {
            nArray[n] = resultSetMetaData.getColumnType(n + 1);
        }
        for (n = 0; n < this.columnIdentifiers.size(); ++n) {
            Object object = this.columnIdentifiers.set(n, objectArray[n]);
        }
        this.types = nArray;
        this.commandString = string;
        this.unlinkedRows = new TreeSet<Integer>();
        this.analyzeForLinking(resultSet, string);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        switch (this.types[n]) {
            case -1: 
            case 1: 
            case 12: {
                return String.class;
            }
            case -7: {
                return Boolean.class;
            }
            case -6: {
                return Byte.class;
            }
            case 5: {
                return Short.class;
            }
            case 4: {
                return Integer.class;
            }
            case -5: {
                return Long.class;
            }
            case 7: {
                return Float.class;
            }
            case 6: 
            case 8: {
                return Double.class;
            }
            case 2: 
            case 3: {
                return BigDecimal.class;
            }
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this.primaryKeys == null || this.primaryKeys.length == 0) {
            return false;
        }
        return super.isCellEditable(n, n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        boolean bl;
        Object object2 = this.getValueAt(n, n2);
        if (object == null) {
            bl = object != object2;
        } else {
            boolean bl2 = bl = !object.equals(object2);
        }
        if (bl) {
            if (this.isLinkedRow(n)) {
                Object[] objectArray = this.columnIdentifiers.toArray();
                try {
                    this.executeUpdate(this.getRowData(objectArray, n), objectArray[n2], object);
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException(sQLException);
                }
            } else if (log.isTraceEnabled()) {
                log.debug("update unlinked row");
            }
        } else if (log.isDebugEnabled()) {
            log.debug("skip to update");
        }
        super.setValueAt(object, n, n2);
    }

    void addUnlinkedRow(Object[] objectArray) {
        this.addUnlinkedRow(ResultSetTableModel.convertToVector(objectArray));
    }

    void addUnlinkedRow(Vector<?> vector) {
        this.addRow(vector);
        this.unlinkedRows.add(this.getRowCount() - 1);
    }

    boolean linkRow(int n) throws SQLException {
        if (this.isLinkedRow(n)) {
            return false;
        }
        this.executeInsert(this.getRowData(this.columnIdentifiers.toArray(), n));
        return this.unlinkedRows.remove(n);
    }

    boolean removeLinkedRow(int n) throws SQLException {
        if (!this.isLinkedRow(n)) {
            return false;
        }
        this.executeDelete(this.getRowData(this.primaryKeys, n));
        super.removeRow(n);
        return true;
    }

    private Map<Object, Object> getRowData(Object[] objectArray, int n) {
        LinkedHashMap<Object, Object> linkedHashMap = new LinkedHashMap<Object, Object>();
        int n2 = objectArray.length;
        for (int i = 0; i < n2; ++i) {
            linkedHashMap.put(objectArray[i], this.getValueAt(n, i));
        }
        return linkedHashMap;
    }

    boolean isUpdatable() {
        return this.updatable;
    }

    boolean isLinkedRow(int n) {
        return !this.unlinkedRows.contains(n);
    }

    boolean isSameConnection(Connection connection) {
        return connection == this.conn;
    }

    String getCommandString() {
        return this.commandString;
    }

    private void executeUpdate(Map<Object, Object> map, Object object, Object object2) throws SQLException {
        String string = String.format("UPDATE %s SET %s=? WHERE %s", this.tableName, ResultSetTableModel.quoteIfNeeds(object), this.getPrimaryKeyClauseString());
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object2);
        for (String string2 : this.primaryKeys) {
            arrayList.add(map.get(string2));
        }
        this.executeSql(string, arrayList.toArray());
    }

    private void executeInsert(Map<Object, Object> map) throws SQLException {
        Set<Object> set = map.keySet();
        String string = String.format("INSERT INTO %s (%s) VALUES (%s)", this.tableName, Iteration.join(set, ", "), Iteration.join(Collections.nCopies(set.size(), "?"), ","));
        this.executeSql(string, map.values().toArray());
    }

    private void executeDelete(Map<Object, Object> map) throws SQLException {
        String string = String.format("DELETE FROM %s WHERE %s", this.tableName, this.getPrimaryKeyClauseString());
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (String string2 : this.primaryKeys) {
            arrayList.add(map.get(string2));
        }
        this.executeSql(string, arrayList.toArray());
    }

    private String getPrimaryKeyClauseString() {
        return Iteration.join(Iteration.map(Arrays.asList(this.primaryKeys), new Iteration.Correspondence<String, String>(){

            @Override
            public String f(String string) {
                return String.format("%s=?", ResultSetTableModel.quoteIfNeeds(string));
            }
        }), " AND ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSql(String string, Object[] objectArray) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("SQL: " + string);
            log.debug("parameters: " + Arrays.asList(objectArray));
        }
        PreparedStatement preparedStatement = this.conn.prepareStatement(string);
        try {
            ValueTransporter valueTransporter = ValueTransporter.getInstance("");
            int n = 0;
            for (Object object : objectArray) {
                boolean bl = false;
                if ((object == null || String.valueOf(object).length() == 0) && this.getColumnClass(n) != String.class) {
                    bl = true;
                }
                ++n;
                if (bl) {
                    preparedStatement.setNull(n, this.types[n - 1]);
                    continue;
                }
                valueTransporter.setObject(preparedStatement, n, object);
            }
            int n2 = preparedStatement.executeUpdate();
            if (n2 != 1) {
                throw new IllegalStateException("updated count = " + n2);
            }
        }
        finally {
            preparedStatement.close();
        }
    }

    static String quoteIfNeeds(Object object) {
        String string = String.valueOf(object);
        if (string.matches(".*\\W.*")) {
            return String.format("\"%s\"", string);
        }
        return string;
    }

    private void analyzeForLinking(ResultSet resultSet, String string) throws SQLException {
        if (resultSet == null) {
            return;
        }
        Statement statement = resultSet.getStatement();
        if (statement == null) {
            return;
        }
        Connection connection = statement.getConnection();
        if (connection == null) {
            return;
        }
        if (connection.isReadOnly()) {
            return;
        }
        String string2 = ResultSetTableModel.findTableName(string);
        if (string2.length() == 0) {
            return;
        }
        List<String> list = ResultSetTableModel.findPrimaryKeys(connection, string2);
        if (list.isEmpty()) {
            return;
        }
        if (ResultSetTableModel.findUnion(string)) {
            return;
        }
        this.conn = connection;
        this.tableName = string2;
        this.primaryKeys = list.toArray(new String[list.size()]);
        this.updatable = true;
    }

    private static String findTableName(String string) {
        Pattern pattern;
        Matcher matcher;
        if (string != null && (matcher = (pattern = Pattern.compile(PTN1, 2)).matcher(string)).find()) {
            String string2;
            String string3 = matcher.group(1);
            String[] stringArray = string3.split("\\s");
            boolean bl = false;
            for (int i = 0; i < 2 && i < stringArray.length; ++i) {
                String string4 = stringArray[i];
                if (string4.indexOf(44) < 0) continue;
                bl = true;
            }
            if (!bl && (string2 = stringArray[0]).matches("[A-Za-z0-9_\\.]+")) {
                return string2;
            }
        }
        return "";
    }

    private static List<String> findPrimaryKeys(Connection connection, String string) throws SQLException {
        Object object;
        Object object2;
        String string2;
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        String string3 = databaseMetaData.getUserName();
        if (string3 == null) {
            string3 = "";
        }
        if (databaseMetaData.storesLowerCaseIdentifiers()) {
            string2 = string3.toLowerCase();
            object2 = string.toLowerCase();
        } else if (databaseMetaData.storesUpperCaseIdentifiers()) {
            string2 = string3.toUpperCase();
            object2 = string.toUpperCase();
        } else {
            string2 = string3;
            object2 = string;
        }
        if (((String)object2).indexOf(46) >= 0) {
            object = ((String)object2).split("\\.");
            string2 = object[0];
            object2 = object[1];
        }
        if ((object = ResultSetTableModel.getPrimaryKeys(databaseMetaData, string2, (String)object2)).isEmpty()) {
            return ResultSetTableModel.getPrimaryKeys(databaseMetaData, null, (String)object2);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getPrimaryKeys(DatabaseMetaData databaseMetaData, String string, String string2) throws SQLException {
        ResultSet resultSet = databaseMetaData.getPrimaryKeys(null, string, string2);
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            HashSet<String> hashSet = new HashSet<String>();
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(4));
                hashSet.add(resultSet.getString(2));
            }
            if (hashSet.size() != 1) {
                arrayList.clear();
            }
            ArrayList<String> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            resultSet.close();
        }
    }

    private static boolean findUnion(String string) {
        String string2 = string;
        if (string2.indexOf("'") >= 0) {
            if (string2.indexOf("\\'") >= 0) {
                string2 = string2.replaceAll("\\'", "");
            }
            string2 = string2.replaceAll("'[^']+'", "''");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (!string3.equalsIgnoreCase("UNION")) continue;
            return true;
        }
        return false;
    }
}

