/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.ui.window;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;
import javax.swing.tree.DefaultTreeModel;
import net.argius.logging.Logger;
import net.argius.logging.LoggerFactory;
import net.argius.stew.CipherPassword;
import net.argius.stew.Command;
import net.argius.stew.Connector;
import net.argius.stew.Environment;
import net.argius.stew.Iteration;
import net.argius.stew.LocalSystem;
import net.argius.stew.io.CsvFormatter;
import net.argius.stew.io.Importer;
import net.argius.stew.io.SmartImporter;
import net.argius.stew.ui.OutputProcessor;
import net.argius.stew.ui.Prompt;
import net.argius.stew.ui.window.ActionUtility;
import net.argius.stew.ui.window.ConnectorEntry;
import net.argius.stew.ui.window.ConnectorMapEditDialog;
import net.argius.stew.ui.window.ConsoleTextArea;
import net.argius.stew.ui.window.DatabaseInfoTree;
import net.argius.stew.ui.window.FontControlLookAndFeel;
import net.argius.stew.ui.window.Menu;
import net.argius.stew.ui.window.Resource;
import net.argius.stew.ui.window.ResultSetTable;
import net.argius.stew.ui.window.ResultSetTableModel;
import net.argius.stew.ui.window.TextSearch;
import net.argius.stew.ui.window.TextSearchPanel;
import net.argius.stew.ui.window.WindowOutputProcessor;

public final class WindowLauncher {
    private static final Logger log = LoggerFactory.getLogger(WindowLauncher.class);
    private static final List<WindowLauncher> instances = Collections.synchronizedList(new ArrayList());
    private static final ImageIcon ICON = Resource.getImageIcon("stew.png");
    JComponent focused;
    private final Environment env;
    private final WindowOutputProcessor op;
    private final JSplitPane sp0;
    private final JSplitPane sp;
    private final ResultSetTable resultSetTable;
    private final ConsoleTextArea textArea;
    private final DatabaseInfoTree infoTree;
    private final TextSearchPanel textSearchPanel;
    private final JLabel statusBar;
    private final List<String> historyList;
    private final ExecutorService executorService;
    private Map<JComponent, TextSearch> textSearchMap;
    private int historyIndex;

    WindowLauncher() {
        instances.add(this);
        ResultSetTable resultSetTable = new ResultSetTable();
        final ConsoleTextArea consoleTextArea = new ConsoleTextArea();
        this.env = new Environment();
        this.op = new WindowOutputProcessor(this.env, resultSetTable, consoleTextArea);
        this.sp0 = new JSplitPane(1);
        this.sp = new JSplitPane();
        this.resultSetTable = resultSetTable;
        this.textArea = consoleTextArea;
        this.infoTree = new DatabaseInfoTree();
        this.textSearchPanel = new TextSearchPanel(this.op);
        this.statusBar = new JLabel(" ");
        this.historyList = new LinkedList<String>();
        this.historyIndex = 0;
        this.executorService = Executors.newScheduledThreadPool(3);
        this.op.setTitle(Resource.getString(".title", new Object[0]));
        this.op.setIconImage(ICON.getImage());
        this.op.setDefaultCloseOperation(0);
        Menu menu = new Menu();
        this.sp.setOrientation(0);
        this.sp.setDividerSize(6);
        this.sp.setResizeWeight(0.6f);
        JScrollPane jScrollPane = new JScrollPane(resultSetTable);
        consoleTextArea.setMargin(new Insets(4, 8, 4, 4));
        consoleTextArea.setLineWrap(true);
        consoleTextArea.setWrapStyleWord(false);
        this.textSearchMap = new LinkedHashMap<JComponent, TextSearch>();
        this.textSearchMap.put(resultSetTable, this.createTextSearch(resultSetTable));
        this.textSearchMap.put(consoleTextArea, this.createTextSearch(consoleTextArea));
        for (TextSearch object2 : this.textSearchMap.values()) {
            this.textSearchPanel.addTarget(object2);
        }
        this.statusBar.setForeground(Color.BLUE);
        JScrollPane jScrollPane2 = new JScrollPane(consoleTextArea);
        jScrollPane2.setVerticalScrollBarPolicy(22);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jScrollPane2, "Center");
        jPanel.add((Component)this.textSearchPanel, "South");
        this.sp.setTopComponent(jScrollPane);
        this.sp.setBottomComponent(jPanel);
        this.op.add((Component)this.statusBar, "Last");
        this.op.setJMenuBar(menu);
        this.sp0.setTopComponent(new JScrollPane(this.infoTree));
        this.sp0.setBottomComponent(this.sp);
        this.op.add((Component)this.sp0, "Center");
        this.setInfoTreePane(false);
        this.op.addPropertyChangeListener(menu);
        this.infoTree.addPropertyChangeListener(menu);
        resultSetTable.addPropertyChangeListener(menu);
        this.statusBar.addPropertyChangeListener(menu);
        this.loadConfiguration();
        this.op.removePropertyChangeListener(menu);
        this.infoTree.removePropertyChangeListener(menu);
        resultSetTable.removePropertyChangeListener(menu);
        this.op.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                WindowLauncher.this.requestClose();
            }
        });
        this.infoTree.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                consoleTextArea.replace(actionEvent.getActionCommand());
            }
        });
        this.bindEvents(resultSetTable, jScrollPane);
        this.bindEvents(consoleTextArea);
        menu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WindowLauncher.this.performMenuEvent(Menu.Item.valueOf(actionEvent.getActionCommand()), (Component)actionEvent.getSource());
            }
        });
        this.env.setOutputProcessor(new WindowOutputProcessor.Bypass(this.op));
        this.op.output(new Prompt(this.env));
        consoleTextArea.requestFocus();
    }

    private void loadConfiguration() {
        Configuration configuration = Configuration.load(LocalSystem.getDirectory());
        this.op.setSize(configuration.getSize());
        this.op.setLocation(configuration.getLocation());
        this.sp.setDividerLocation(configuration.getDividerLocation());
        this.statusBar.setVisible(configuration.isShowStatusBar());
        this.resultSetTable.setShowColumnNumber(configuration.isShowTableColumnNumber());
        this.setInfoTreePane(configuration.isShowInfoTree());
        this.op.setAlwaysOnTop(configuration.isAlwaysOnTop());
        this.op.setAutoAdjustMode(Menu.Item.valueOf(configuration.getAutoAdjustMode()));
        this.changeFont("monospaced", 0, 1.0);
    }

    private void saveConfiguration() {
        Configuration configuration = Configuration.load(LocalSystem.getDirectory());
        if ((this.op.getExtendedState() & 6) == 0) {
            configuration.setSize(this.op.getSize());
            configuration.setLocation(this.op.getLocation());
            configuration.setDividerLocation(this.sp.getDividerLocation());
        }
        configuration.setShowStatusBar(this.statusBar.isVisible());
        configuration.setShowTableColumnNumber(this.resultSetTable.isShowColumnNumber());
        configuration.setShowInfoTree(this.infoTree.isEnabled());
        configuration.setAlwaysOnTop(this.op.isAlwaysOnTop());
        configuration.setAutoAdjustMode(this.op.getAutoAdjustMode().name());
        configuration.save();
    }

    private void changeFont(String string, int n, double d) {
        FontControlLookAndFeel.change(string, n, d);
        SwingUtilities.updateComponentTreeUI(this.op);
        Font font = this.textArea.getFont();
        if (font != null) {
            this.statusBar.setFont(font.deriveFont((float)font.getSize() * 0.8f));
        }
    }

    private void bindEvents(final ResultSetTable resultSetTable, JScrollPane jScrollPane) {
        int n = Resource.getMenuShortcutKeyMask();
        ActionUtility actionUtility = new ActionUtility(resultSetTable);
        final AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                resultSetTable.editingCanceled(new ChangeEvent(actionEvent.getSource()));
            }
        };
        actionUtility.bindAction(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int n : resultSetTable.getSelectedRows()) {
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    for (int n2 : resultSetTable.getSelectedColumns()) {
                        Object object = resultSetTable.getValueAt(n, n2);
                        arrayList2.add(CsvFormatter.AUTO.format(object == null ? "" : String.valueOf(object)));
                    }
                    arrayList.add(Iteration.join(arrayList2, "\t"));
                }
                WindowLauncher.setClipboard(Iteration.join(arrayList, "\n"));
            }
        }, "copyWithEscape", KeyStroke.getKeyStroke(67, n | 0x200));
        actionUtility.bindAction(new AbstractAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(WindowLauncher.getClipboard().getBytes());
                    SmartImporter smartImporter = new SmartImporter(byteArrayInputStream, "\t");
                    try {
                        int[] nArray = resultSetTable.getSelectedColumns();
                        for (int n : resultSetTable.getSelectedRows()) {
                            Object[] objectArray = ((Importer)smartImporter).nextRow();
                            int n2 = Math.min(nArray.length, objectArray.length);
                            for (int i = 0; i < n2; ++i) {
                                resultSetTable.setValueAt(objectArray[i], n, nArray[i]);
                            }
                        }
                    }
                    finally {
                        ((Importer)smartImporter).close();
                    }
                    resultSetTable.repaint();
                }
                catch (Exception exception) {
                    WindowLauncher.this.handleError(exception);
                }
                finally {
                    abstractAction.actionPerformed(actionEvent);
                }
            }
        }, "paste");
        actionUtility.bindAction(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ArrayList<String> arrayList = new ArrayList<String>();
                ResultSetTableModel resultSetTableModel = resultSetTable.getResultSetTableModel();
                int n = resultSetTableModel.getColumnCount();
                for (int i = 0; i < n; ++i) {
                    arrayList.add(resultSetTableModel.getColumnName(i));
                }
                WindowLauncher.setClipboard(Iteration.join(arrayList, "\t"));
            }
        }, "copyColumnNames");
        actionUtility.bindAction(new AbstractAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int[] nArray = resultSetTable.getSelectedColumns();
                    for (int n : resultSetTable.getSelectedRows()) {
                        int n2 = nArray.length;
                        for (int i = 0; i < n2; ++i) {
                            resultSetTable.setValueAt(null, n, nArray[i]);
                        }
                    }
                    resultSetTable.repaint();
                }
                catch (Exception exception) {
                    WindowLauncher.this.handleError(exception);
                }
                finally {
                    abstractAction.actionPerformed(actionEvent);
                }
            }
        }, "clearCells", KeyStroke.getKeyStroke(127, 0));
        actionUtility.bindAction(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultSetTableModel resultSetTableModel = resultSetTable.getResultSetTableModel();
                resultSetTableModel.addUnlinkedRow(new Object[resultSetTableModel.getColumnCount()]);
            }
        }, "addEmptyRow");
        actionUtility.bindAction(new AbstractAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(WindowLauncher.getClipboard().getBytes());
                    SmartImporter smartImporter = new SmartImporter(byteArrayInputStream, "\t");
                    try {
                        Object[] objectArray;
                        ResultSetTableModel resultSetTableModel = resultSetTable.getResultSetTableModel();
                        while ((objectArray = ((Importer)smartImporter).nextRow()).length != 0) {
                            resultSetTableModel.addUnlinkedRow(objectArray);
                            resultSetTableModel.linkRow(resultSetTableModel.getRowCount() - 1);
                        }
                        resultSetTable.repaintRowHeader("model");
                    }
                    finally {
                        ((Importer)smartImporter).close();
                    }
                }
                catch (Exception exception) {
                    WindowLauncher.this.handleError(exception);
                }
                finally {
                    abstractAction.actionPerformed(actionEvent);
                }
            }
        }, "insertFromClipboard");
        actionUtility.bindAction(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultSetTableModel resultSetTableModel = resultSetTable.getResultSetTableModel();
                Vector<Vector> vector = resultSetTableModel.getDataVector();
                for (int n : resultSetTable.getSelectedRows()) {
                    resultSetTableModel.addUnlinkedRow((Vector)((Vector)vector.get(n)).clone());
                }
                resultSetTable.repaint();
                resultSetTable.repaintRowHeader("model");
            }
        }, "duplicateRows");
        actionUtility.bindAction(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultSetTableModel resultSetTableModel = resultSetTable.getResultSetTableModel();
                try {
                    for (int n : resultSetTable.getSelectedRows()) {
                        resultSetTableModel.linkRow(n);
                    }
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException(sQLException);
                }
                finally {
                    resultSetTable.repaintRowHeader("rowSuspendedStatus");
                }
            }
        }, "linkRowsToDatabase");
        actionUtility.bindAction(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultSetTableModel resultSetTableModel = resultSetTable.getResultSetTableModel();
                try {
                    for (int n : resultSetTable.getSelectedRows()) {
                        if (resultSetTableModel.isLinkedRow(n)) {
                            boolean bl = resultSetTableModel.removeLinkedRow(n);
                            assert (bl);
                            continue;
                        }
                        resultSetTableModel.removeRow(n);
                    }
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException(sQLException);
                }
                finally {
                    resultSetTable.repaintRowHeader("model");
                }
            }
        }, "deleteRows", KeyStroke.getKeyStroke(45, n | 0x40));
        JPopupMenu jPopupMenu = new JPopupMenu();
        final ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
        for (String string : new String[]{"copy", "copyWithEscape", "paste", "copyColumnNames", "clearCells", "selectAll", "", "addEmptyRow", "insertFromClipboard", "duplicateRows", "linkRowsToDatabase", "deleteRows"}) {
            if (string.length() == 0) {
                jPopupMenu.addSeparator();
                continue;
            }
            String string2 = Resource.getString("Action." + string, new Object[0]);
            jPopupMenu.add(actionUtility.copyActionTo(string, new JMenuItem(string2)));
            if (!string.equals("paste") && !string.equals("clearCells") && !string.equals("addEmptyRow") && !string.equals("insertFromClipboard") && !string.equals("duplicateRows") && !string.equals("linkRowsToDatabase") && !string.equals("deleteRows")) continue;
            arrayList.add(new JMenuItem(string2));
        }
        jPopupMenu.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                ResultSetTableModel resultSetTableModel = resultSetTable.getResultSetTableModel();
                boolean bl = resultSetTableModel.isUpdatable();
                for (JMenuItem jMenuItem : arrayList) {
                    jMenuItem.setEnabled(bl);
                }
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
        resultSetTable.setComponentPopupMenu(jPopupMenu);
        this.bindEvents(resultSetTable.getTableHeader(), actionUtility);
        this.bindEvents(resultSetTable.getRowHeader(), actionUtility);
    }

    private void bindEvents(final JTableHeader jTableHeader, ActionUtility actionUtility) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        final Point point = new Point();
        final WindowOutputProcessor windowOutputProcessor = this.op;
        jPopupMenu.add(new JMenuItem(new AbstractAction("sort"){

            public void actionPerformed(ActionEvent actionEvent) {
                windowOutputProcessor.sortTable(jTableHeader.columnAtPoint(point));
            }
        }));
        for (String string : new String[]{"copy", "copyWithEscape", "paste", "clearCells", "copyColumnNames", "", "addEmptyRow", "insertFromClipboard"}) {
            if (string.length() == 0) {
                jPopupMenu.addSeparator();
                continue;
            }
            jPopupMenu.add(actionUtility.copyActionTo(string, new JMenuItem(Resource.getString("Action." + string, new Object[0]))));
        }
        jTableHeader.setComponentPopupMenu(jPopupMenu);
    }

    private void bindEvents(JTable jTable, ActionUtility actionUtility) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        for (String string : new String[]{"copy", "copyWithEscape", "paste", "clearCells", "copyColumnNames", "", "addEmptyRow", "insertFromClipboard"}) {
            if (string.length() == 0) {
                jPopupMenu.addSeparator();
                continue;
            }
            jPopupMenu.add(actionUtility.copyActionTo(string, new JMenuItem(Resource.getString("Action." + string, new Object[0]))));
        }
        jTable.setComponentPopupMenu(jPopupMenu);
    }

    private void bindEvents(final ConsoleTextArea consoleTextArea) {
        ActionUtility actionUtility = new ActionUtility(consoleTextArea);
        final WindowOutputProcessor windowOutputProcessor = this.op;
        consoleTextArea.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WindowLauncher.this.executeCommand(actionEvent.getActionCommand());
            }
        });
        consoleTextArea.setDropTarget(new DropTarget(consoleTextArea, new DropTargetAdapter(){

            public void drop(DropTargetDropEvent dropTargetDropEvent) {
                List list;
                Object object;
                Transferable transferable = dropTargetDropEvent.getTransferable();
                if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    dropTargetDropEvent.acceptDrop(3);
                    try {
                        object = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                        list = object;
                    }
                    catch (UnsupportedFlavorException unsupportedFlavorException) {
                        throw new RuntimeException(unsupportedFlavorException);
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException);
                    }
                } else {
                    throw new IllegalStateException("Transferable=" + transferable);
                }
                object = new JPopupMenu();
                ((JPopupMenu)object).add(new JMenuItem(new AbstractAction(Resource.getString("Action.paste-path", new Object[0])){

                    public void actionPerformed(ActionEvent actionEvent) {
                        windowOutputProcessor.output(" " + Iteration.join(list, " "));
                    }
                }));
                ((JPopupMenu)object).add(new JMenuItem(new AbstractAction(Resource.getString("Action.paste-file-content", new Object[0])){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            for (File file : list) {
                                Scanner scanner = new Scanner(file);
                                try {
                                    while (scanner.hasNextLine()) {
                                        windowOutputProcessor.output(String.format("%s%n", scanner.nextLine()));
                                    }
                                }
                                finally {
                                    scanner.close();
                                }
                            }
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            throw new RuntimeException(fileNotFoundException);
                        }
                    }
                }));
                Point point = dropTargetDropEvent.getLocation();
                ((JPopupMenu)object).show(consoleTextArea, point.x, point.y);
            }
        }));
        actionUtility.setActionForTextComponent();
    }

    private TextSearch createTextSearch(final ResultSetTable resultSetTable) {
        TextSearch textSearch = new TextSearch(){

            public boolean search(TextSearch.Matcher matcher) {
                int n = resultSetTable.getRowCount();
                if (n <= 0) {
                    return false;
                }
                int n2 = resultSetTable.getColumnCount();
                boolean bl = matcher.isBackward();
                int n3 = bl ? -1 : 1;
                int n4 = bl ? n - 1 : 0;
                int n5 = bl ? 0 : n - 1;
                int n6 = bl ? n2 - 1 : 0;
                int n7 = bl ? 0 : n2 - 1;
                int n8 = n4;
                int n9 = n6;
                if (resultSetTable.getSelectedColumnCount() > 0) {
                    n9 = resultSetTable.getSelectedColumn();
                    n8 = resultSetTable.getSelectedRow() + n3;
                    if (bl) {
                        if (n8 < 0) {
                            if (--n9 < 0) {
                                return false;
                            }
                            n8 = n4;
                        }
                    } else if (n8 >= n) {
                        if (++n9 >= n2) {
                            return false;
                        }
                        n8 = n4;
                    }
                }
                TableModel tableModel = resultSetTable.getModel();
                while (bl ? n9 >= n7 : n9 <= n7) {
                    while (bl ? n8 >= n5 : n8 <= n5) {
                        if (matcher.find(String.valueOf(tableModel.getValueAt(n8, n9)))) {
                            resultSetTable.changeSelection(n8, n9, false, false);
                            resultSetTable.requestFocus();
                            return true;
                        }
                        n8 += n3;
                    }
                    n8 = n4;
                    n9 += n3;
                }
                return false;
            }

            public void reset() {
            }
        };
        resultSetTable.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                WindowLauncher.this.focused = resultSetTable;
            }
        });
        return textSearch;
    }

    private TextSearch createTextSearch(final ConsoleTextArea consoleTextArea) {
        TextSearch textSearch = new TextSearch(){

            public boolean search(TextSearch.Matcher matcher) {
                this.removeHighlights();
                try {
                    Highlighter highlighter = consoleTextArea.getHighlighter();
                    Highlighter.HighlightPainter highlightPainter = matcher.getHighlightPainter();
                    String string = consoleTextArea.getText();
                    int n = 0;
                    boolean bl = false;
                    while (matcher.find(string, n)) {
                        bl = true;
                        int n2 = matcher.getStart();
                        highlighter.addHighlight(n2, matcher.getEnd(), highlightPainter);
                        n = n2 + 1;
                    }
                    consoleTextArea.addKeyListener(new KeyAdapter(){

                        public void keyTyped(KeyEvent keyEvent) {
                            consoleTextArea.removeKeyListener(this);
                            this.removeHighlights();
                        }
                    });
                    return bl;
                }
                catch (BadLocationException badLocationException) {
                    throw new RuntimeException(badLocationException);
                }
            }

            public void reset() {
                this.removeHighlights();
            }

            void removeHighlights() {
                for (Highlighter.Highlight highlight : consoleTextArea.getHighlighter().getHighlights()) {
                    consoleTextArea.getHighlighter().removeHighlight(highlight);
                }
            }
        };
        consoleTextArea.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                WindowLauncher.this.focused = consoleTextArea;
            }
        });
        return textSearch;
    }

    static String getClipboard() throws IOException {
        String string;
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            Transferable transferable = clipboard.getContents(null);
            string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            IOException iOException = new IOException();
            iOException.initCause(iOException);
            throw iOException;
        }
        if (log.isTraceEnabled()) {
            log.trace(String.format("get clipboard:[%s]", string));
        }
        return string;
    }

    static void setClipboard(String string) {
        if (log.isTraceEnabled()) {
            log.trace(String.format("set clipboard:[%s]", string));
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(string);
        clipboard.setContents(stringSelection, stringSelection);
    }

    void handleError(Throwable throwable) {
        log.error("", throwable);
        this.op.showErrorDialog(throwable);
    }

    void performMenuEvent(Menu.Item item, Component component) {
        try {
            this.resultSetTable.editingCanceled(new ChangeEvent(component));
        }
        catch (Exception exception) {
            this.handleError(exception);
        }
        switch (item) {
            case NEW: {
                WindowLauncher.invoke();
                break;
            }
            case CLOSE: {
                this.requestClose();
                break;
            }
            case QUIT: {
                this.requestExit();
                break;
            }
            case CUT: 
            case COPY: 
            case PASTE: 
            case SELECT_ALL: {
                KeyStroke keyStroke = ((JMenuItem)component).getAccelerator();
                ActionListener actionListener = this.focused.getActionForKeyStroke(keyStroke);
                if (actionListener == null) break;
                actionListener.actionPerformed(new ActionEvent(this.focused, 1001, ""));
                break;
            }
            case FIND: {
                this.textSearchPanel.setCurrentTarget(this.textSearchMap.get(this.focused));
                this.textSearchPanel.setVisible(true);
                break;
            }
            case TOGGLE_FOCUS: {
                if (this.textArea.isFocusOwner()) {
                    this.resultSetTable.requestFocus();
                    break;
                }
                this.textArea.requestFocus();
                break;
            }
            case CLEAR_MESSAGE: {
                this.textArea.clear();
                this.executeCommand("");
                break;
            }
            case STATUS_BAR: {
                this.statusBar.setVisible(((JCheckBoxMenuItem)component).isSelected());
                break;
            }
            case COLUMN_NUMBER: {
                this.resultSetTable.setShowColumnNumber(((JCheckBoxMenuItem)component).isSelected());
                this.sp.getTopComponent().repaint();
                break;
            }
            case INFO_TREE: {
                this.setInfoTreePane(((JCheckBoxMenuItem)component).isSelected());
                this.op.validate();
                this.op.repaint();
                break;
            }
            case ALWAYS_ON_TOP: {
                this.op.setAlwaysOnTop(((JCheckBoxMenuItem)component).isSelected());
                break;
            }
            case WIDEN: {
                this.op.changeTableColumnWidth(1.5);
                break;
            }
            case NARROW: {
                this.op.changeTableColumnWidth(0.6666666865348816);
                break;
            }
            case ADJUST_COLUMN_WIDTH: {
                this.op.adjustTableColumnWidth();
                break;
            }
            case AUTO_ADJUST_MODE_NONE: 
            case AUTO_ADJUST_MODE_HEADER: 
            case AUTO_ADJUST_MODE_VALUE: 
            case AUTO_ADJUST_MODE_HEADERANDVALUE: {
                this.op.setAutoAdjustMode(item);
                break;
            }
            case REFRESH: {
                String string;
                ResultSetTableModel resultSetTableModel = this.resultSetTable.getResultSetTableModel();
                if (!resultSetTableModel.isSameConnection(this.env.getCurrentConnection()) || (string = resultSetTableModel.getCommandString()) == null || string.length() <= 0) break;
                this.executeCommand(string);
                break;
            }
            case EXECUTE: {
                this.executeCommand(this.textArea.getEditableText());
                break;
            }
            case BREAK: {
                this.env.getOutputProcessor().close();
                this.env.setOutputProcessor(new WindowOutputProcessor.Bypass(this.op));
                this.op.output(Resource.getString("i.cancelled", new Object[0]));
                this.doPostProcess();
                break;
            }
            case HISTORY_BACK: {
                if (this.historyList.isEmpty()) {
                    return;
                }
                --this.historyIndex;
                if (this.historyIndex < 0) {
                    this.historyIndex = this.historyList.size() - 1;
                }
                this.textArea.replace(this.historyList.get(this.historyIndex));
                this.textArea.requestFocus();
                break;
            }
            case HISTORY_NEXT: {
                if (this.historyList.isEmpty()) {
                    return;
                }
                ++this.historyIndex;
                if (this.historyIndex >= this.historyList.size()) {
                    this.historyIndex = 0;
                }
                this.textArea.replace(this.historyList.get(this.historyIndex));
                this.textArea.requestFocus();
                break;
            }
            case CONNECT: {
                if (this.env.getConnectorMap().isEmpty()) {
                    JOptionPane.showMessageDialog(this.op, Resource.getString("w.no-connector", new Object[0]));
                    return;
                }
                Object[] objectArray = ConnectorEntry.toList(this.env.getConnectorMap().values()).toArray();
                String string = Resource.getString("i.choose-connection", new Object[0]);
                Object object = JOptionPane.showInputDialog(this.op, string, null, -1, null, objectArray, objectArray[0]);
                if (object == null) break;
                ConnectorEntry connectorEntry = (ConnectorEntry)object;
                this.executeCommand("connect " + connectorEntry.getId());
                break;
            }
            case DISCONNECT: {
                this.executeCommand("disconnect");
                break;
            }
            case ENCRYPTION_KEY: {
                JPasswordField jPasswordField = new JPasswordField(20);
                Object[] objectArray = new Object[]{Resource.getString("i.input-encryption-key", new Object[0]), jPasswordField};
                if (JOptionPane.showConfirmDialog(this.op, objectArray, null, 2) != 0) break;
                CipherPassword.setSecretKey(String.valueOf(jPasswordField.getPassword()));
                break;
            }
            case EDIT_CONNECTORS: {
                this.env.updateConnectorMap();
                if (this.env.getCurrentConnector() != null) {
                    JOptionPane.showMessageDialog(this.op, Resource.getString("i.reconnect-after-edited-current-connector", new Object[0]));
                }
                ConnectorMapEditDialog connectorMapEditDialog = new ConnectorMapEditDialog(this.op, this.env);
                connectorMapEditDialog.pack();
                connectorMapEditDialog.setModal(true);
                connectorMapEditDialog.setLocationRelativeTo(this.op);
                connectorMapEditDialog.setVisible(true);
                this.env.updateConnectorMap();
                break;
            }
            case SORT: {
                this.op.sortTable(this.resultSetTable.getSelectedColumn());
                break;
            }
            case EXPORT: {
                try {
                    this.op.exportTableContent();
                    break;
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
            case HELP: {
                JOptionPane.showMessageDialog(this.op, Resource.getString("i.help-see-release-package", new Object[0]), null, -1);
                break;
            }
            case ABOUT: {
                ImageIcon imageIcon = new ImageIcon();
                if (this.op.getIconImage() != null) {
                    imageIcon.setImage(this.op.getIconImage());
                }
                JOptionPane.showMessageDialog(this.op, Resource.getString(".about", Resource.getVersion()), null, -1, imageIcon);
                break;
            }
            default: {
                log.warn(String.format("ignored [%s] (%s)", new Object[]{item, component}));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void invoke() {
        block6: {
            WindowLauncher windowLauncher = new WindowLauncher();
            windowLauncher.op.setVisible(true);
            windowLauncher.textArea.requestFocus();
            try {
                File file = new File(LocalSystem.getDirectory(), "keybind.conf");
                if (!file.exists()) break block6;
                ArrayList<String> arrayList = new ArrayList<String>();
                Scanner scanner = new Scanner(file);
                try {
                    while (scanner.hasNextLine()) {
                        arrayList.add(scanner.nextLine());
                    }
                }
                finally {
                    scanner.close();
                }
                Menu.changeKeyBinds(arrayList);
            }
            catch (Exception exception) {
                windowLauncher.handleError(exception);
            }
        }
    }

    static void exit() {
        for (WindowLauncher windowLauncher : new ArrayList<WindowLauncher>(instances)) {
            try {
                windowLauncher.close();
            }
            catch (Exception exception) {
                log.warn("error occurred when closing all instances", exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        instances.remove(this);
        try {
            this.env.release();
            this.saveConfiguration();
            this.executorService.shutdown();
        }
        finally {
            this.op.dispose();
        }
    }

    private boolean isConfirmYes(String string) {
        return JOptionPane.showConfirmDialog(this.op, string, "", 0) == 0;
    }

    void requestClose() {
        if (instances.size() == 1) {
            this.requestExit();
        } else if (this.env.getCurrentConnection() == null || this.isConfirmYes(Resource.getString("i.confirm-close", new Object[0]))) {
            this.close();
        }
    }

    private void requestExit() {
        if (this.isConfirmYes(Resource.getString("i.confirm-quit", new Object[0]))) {
            WindowLauncher.exit();
        }
    }

    void setInfoTreePane(boolean bl) {
        if (bl) {
            this.infoTree.setEnabled(true);
            this.sp0.setDividerSize(4);
            this.sp0.setResizeWeight(0.6f);
            this.sp0.setDividerLocation(0.3f);
        } else {
            this.sp0.setDividerSize(0);
            this.sp0.setResizeWeight(0.0);
            this.sp0.setDividerLocation(0.0);
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.infoTree.getModel();
            defaultTreeModel.setRoot(null);
            this.infoTree.setEnabled(false);
        }
    }

    void executeCommand(String string) {
        assert (string != null);
        this.textArea.replace(String.format("%s%n", string));
        if (string.trim().length() == 0) {
            this.doPostProcess();
        } else {
            final String string2 = string;
            final Environment environment = this.env;
            final WindowOutputProcessor windowOutputProcessor = this.op;
            final DatabaseInfoTree databaseInfoTree = this.infoTree;
            final JLabel jLabel = this.statusBar;
            final OutputProcessor outputProcessor = environment.getOutputProcessor();
            try {
                this.doPreProcess();
                this.executorService.execute(new Runnable(){

                    public void run() {
                        Connector connector = environment.getCurrentConnector();
                        windowOutputProcessor.setCurrentCommand(string2);
                        long l = System.currentTimeMillis();
                        if (!Command.invoke(environment, string2)) {
                            WindowLauncher.exit();
                        }
                        if (databaseInfoTree.isEnabled() && environment.getCurrentConnector() != connector) {
                            try {
                                databaseInfoTree.refreshRoot(environment);
                            }
                            catch (Throwable throwable) {
                                WindowLauncher.this.handleError(throwable);
                            }
                        }
                        if (environment.getOutputProcessor() == outputProcessor) {
                            l = System.currentTimeMillis() - l;
                            jLabel.setText(Resource.getString("i.statusbar-message", Float.valueOf((float)l / 1000.0f), string2));
                            WindowLauncher.this.doPostProcess();
                        }
                    }
                });
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            if (this.historyList.contains(string)) {
                this.historyList.remove(string);
            }
            this.historyList.add(string);
            this.historyIndex = this.historyList.size();
        }
    }

    void doPreProcess() {
        ((Menu)this.op.getJMenuBar()).setEnabledStates(true);
        this.resultSetTable.setEnabled(false);
        this.textArea.setEnabled(false);
        this.op.repaint();
    }

    void doPostProcess() {
        ((Menu)this.op.getJMenuBar()).setEnabledStates(false);
        this.resultSetTable.setEnabled(true);
        this.textArea.setEnabled(true);
        this.op.output(new Prompt(this.env));
        this.textArea.requestFocus();
    }

    static void wakeup() {
        for (WindowLauncher windowLauncher : new ArrayList<WindowLauncher>(instances)) {
            try {
                windowLauncher.op.repaint();
            }
            catch (Exception exception) {
                log.warn("", exception);
            }
        }
        if (log.isInfoEnabled()) {
            log.info("wake up");
        }
    }

    public static void main(String ... stringArray) {
        int n = LocalSystem.getPropertyAsInt("net.argius.stew.ui.window.resident");
        if (n > 0) {
            long l = (long)n * 60000L;
            Timer timer = new Timer(true);
            timer.scheduleAtFixedRate(new TimerTask(){

                public void run() {
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            WindowLauncher.wakeup();
                        }
                    });
                }
            }, l, l);
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                WindowLauncher.invoke();
            }
        });
    }

    public static final class Configuration {
        private static final Logger log = LoggerFactory.getLogger(Configuration.class);
        private transient File directory;
        private Dimension size = new Dimension(640, 480);
        private Point location = new Point(200, 200);
        private int dividerLocation = -1;
        private boolean showStatusBar = false;
        private boolean showTableColumnNumber = false;
        private boolean showInfoTree = false;
        private boolean alwaysOnTop = false;
        private String autoAdjustMode = Menu.Item.AUTO_ADJUST_MODE_NONE.name();

        void setDirectory(File file) {
            this.directory = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void save() {
            File file = Configuration.getFile(this.directory);
            if (log.isDebugEnabled()) {
                log.debug(String.format("save Configuration to: [%s]", file));
            }
            try {
                XMLEncoder xMLEncoder = new XMLEncoder(new FileOutputStream(file));
                try {
                    xMLEncoder.writeObject(this);
                }
                finally {
                    xMLEncoder.close();
                }
            }
            catch (Exception exception) {
                log.warn("", exception);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static Configuration load(File file) {
            File file2 = Configuration.getFile(file);
            if (log.isDebugEnabled()) {
                log.debug(String.format("load Configuration from: [%s]", file2));
            }
            if (file2.exists()) {
                XMLDecoder xMLDecoder = new XMLDecoder(new FileInputStream(file2));
                try {
                    Configuration configuration = (Configuration)xMLDecoder.readObject();
                    configuration.setDirectory(file);
                    Configuration configuration2 = configuration;
                    xMLDecoder.close();
                    return configuration2;
                }
                catch (Throwable throwable) {
                    try {
                        xMLDecoder.close();
                        throw throwable;
                    }
                    catch (Exception exception) {
                        log.warn("", exception);
                    }
                }
            }
            Configuration configuration = new Configuration();
            configuration.setDirectory(file);
            return configuration;
        }

        private static File getFile(File file) {
            File file2 = new File(file, Configuration.class.getName() + ".xml");
            return file2.getAbsoluteFile();
        }

        public Dimension getSize() {
            return this.size;
        }

        public void setSize(Dimension dimension) {
            this.size = dimension;
        }

        public Point getLocation() {
            return this.location;
        }

        public void setLocation(Point point) {
            this.location = point;
        }

        public int getDividerLocation() {
            return this.dividerLocation;
        }

        public void setDividerLocation(int n) {
            this.dividerLocation = n;
        }

        public boolean isShowStatusBar() {
            return this.showStatusBar;
        }

        public void setShowStatusBar(boolean bl) {
            this.showStatusBar = bl;
        }

        public boolean isShowTableColumnNumber() {
            return this.showTableColumnNumber;
        }

        public void setShowTableColumnNumber(boolean bl) {
            this.showTableColumnNumber = bl;
        }

        public boolean isShowInfoTree() {
            return this.showInfoTree;
        }

        public void setShowInfoTree(boolean bl) {
            this.showInfoTree = bl;
        }

        public boolean isAlwaysOnTop() {
            return this.alwaysOnTop;
        }

        public void setAlwaysOnTop(boolean bl) {
            this.alwaysOnTop = bl;
        }

        public String getAutoAdjustMode() {
            return this.autoAdjustMode;
        }

        public void setAutoAdjustMode(String string) {
            this.autoAdjustMode = string;
        }
    }
}

