/*
 *  Copyright 2010 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.stew.command;

import java.sql.*;

import net.argius.stew.*;

/**
 *  
 */
public final class Wait extends Command {

    @Override
    public void execute(Connection conn, Parameter parameter) throws CommandException {
        try {
            final double seconds = Double.parseDouble(parameter.get(2));
            final long millisecs = (long)(seconds * 1000L);
            output(String.format("wait: %.3f secs", seconds));
            try {
                Thread.sleep(millisecs);
            } catch (InterruptedException ex) {
                output("interrupted");
            }
        } catch (NumberFormatException ex) {
            throw new UsageException("wait seconds");
        }
    }

}
