/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formattable;
import java.util.Formatter;

public final class PrintFormat {
    public static String format(String string, Object ... objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object : objectArray) {
            Object object2 = object == null || object instanceof CharSequence ? new FullwidthFormatter(object == null ? "" : object.toString()) : object;
            arrayList.add(object2);
        }
        try {
            return String.format(string, arrayList.toArray());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static final class FullwidthFormatter
    implements Formattable {
        private static final char SPACE = ' ';
        private final char[] chars;
        private final int length;

        FullwidthFormatter(String string) {
            this.chars = string.toCharArray();
            this.length = this.chars.length;
        }

        public void formatTo(Formatter formatter, int n, int n2, int n3) {
            boolean bl = (n & 1) == 1;
            StringBuilder stringBuilder = new StringBuilder(n2);
            int n4 = 0;
            for (int i = 0; i < this.length; ++i) {
                int n5 = bl ? i : this.length - 1 - i;
                char c = this.chars[n5];
                if (bl) {
                    stringBuilder.append(c);
                } else {
                    stringBuilder.insert(0, c);
                }
                int n6 = FullwidthFormatter.getWidth(c);
                if (++n4 >= n2) {
                    if (n6 != 2) break;
                    stringBuilder.setCharAt(n5, ' ');
                    break;
                }
                if (n6 != 2) continue;
                ++n4;
            }
            if (n4 < n2) {
                char[] cArray = new char[n2 - n4];
                Arrays.fill(cArray, ' ');
                if (bl) {
                    stringBuilder.append(cArray);
                } else {
                    stringBuilder.insert(0, cArray);
                }
            }
            formatter.format(stringBuilder.toString(), new Object[0]);
        }

        private static int getWidth(char c) {
            return c > '\u00ff' && (c < '\uff61' || c > '\uff9f') ? 2 : 1;
        }
    }
}

