/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.ui.window;

import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.JTableHeader;
import net.argius.stew.Iteration;
import net.argius.stew.io.CsvFormatter;
import net.argius.stew.io.Importer;
import net.argius.stew.io.SmartImporter;
import net.argius.stew.ui.window.ActionUtility;
import net.argius.stew.ui.window.ConsoleTextArea;
import net.argius.stew.ui.window.DatabaseInfoTree;
import net.argius.stew.ui.window.Resource;
import net.argius.stew.ui.window.ResultSetTable;
import net.argius.stew.ui.window.ResultSetTableModel;
import net.argius.stew.ui.window.WindowLauncher;
import net.argius.stew.ui.window.WindowLauncher3;
import net.argius.stew.ui.window.WindowOutputProcessor;

final class WindowLauncher1 {
    private WindowLauncher1() {
    }

    static void bindEvents(DatabaseInfoTree databaseInfoTree, final ConsoleTextArea consoleTextArea) {
        ActionUtility actionUtility = ActionUtility.getInstance(databaseInfoTree);
        databaseInfoTree.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                consoleTextArea.replaceSelection(actionEvent.getActionCommand());
                consoleTextArea.requestFocus();
            }
        });
        actionUtility.setContextMenu(new String[]{"copy-full-name", "refresh", "generate-where-phrase", "generate-select-phrase", "generate-update-statement", "generate-insert-statement"}, "FRWSUI".toCharArray());
    }

    static void bindEvents(final ResultSetTable resultSetTable, final WindowOutputProcessor windowOutputProcessor) {
        ActionUtility actionUtility = ActionUtility.getInstance(resultSetTable);
        int n = Resource.getMenuShortcutKeyMask();
        final AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                resultSetTable.editingCanceled(new ChangeEvent(actionEvent.getSource()));
            }
        };
        actionUtility.bindAction((Action)new AbstractAction("copyWithEscape"){

            public void actionPerformed(ActionEvent actionEvent) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int n : resultSetTable.getSelectedRows()) {
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    for (int n2 : resultSetTable.getSelectedColumns()) {
                        Object object = resultSetTable.getValueAt(n, n2);
                        arrayList2.add(CsvFormatter.AUTO.format(object == null ? "" : String.valueOf(object)));
                    }
                    arrayList.add(Iteration.join(arrayList2, "\t"));
                }
                WindowLauncher3.setClipboard(Iteration.join(arrayList, "\n"));
            }
        }, KeyStroke.getKeyStroke(67, n | 0x200));
        actionUtility.bindAction((Action)new AbstractAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(WindowLauncher3.getClipboard().getBytes());
                    SmartImporter smartImporter = new SmartImporter(byteArrayInputStream, "\t");
                    try {
                        int[] nArray = resultSetTable.getSelectedColumns();
                        for (int n : resultSetTable.getSelectedRows()) {
                            Object[] objectArray = ((Importer)smartImporter).nextRow();
                            int n2 = Math.min(nArray.length, objectArray.length);
                            for (int i = 0; i < n2; ++i) {
                                resultSetTable.setValueAt(objectArray[i], n, nArray[i]);
                            }
                        }
                    }
                    finally {
                        ((Importer)smartImporter).close();
                    }
                    resultSetTable.repaint();
                }
                catch (Exception exception) {
                    WindowLauncher3.handleError(exception, windowOutputProcessor);
                }
                finally {
                    abstractAction.actionPerformed(actionEvent);
                }
            }
        }, "paste");
        actionUtility.bindAction((Action)new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ArrayList<String> arrayList = new ArrayList<String>();
                ResultSetTableModel resultSetTableModel = resultSetTable.getResultSetTableModel();
                int n = resultSetTableModel.getColumnCount();
                for (int i = 0; i < n; ++i) {
                    arrayList.add(resultSetTableModel.getColumnName(i));
                }
                WindowLauncher3.setClipboard(Iteration.join(arrayList, "\t"));
            }
        }, "copyColumnNames");
        actionUtility.bindAction((Action)new AbstractAction("clearCells"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int[] nArray = resultSetTable.getSelectedColumns();
                    for (int n : resultSetTable.getSelectedRows()) {
                        int n2 = nArray.length;
                        for (int i = 0; i < n2; ++i) {
                            resultSetTable.setValueAt(null, n, nArray[i]);
                        }
                    }
                    resultSetTable.repaint();
                }
                catch (Exception exception) {
                    WindowLauncher3.handleError(exception, windowOutputProcessor);
                }
                finally {
                    abstractAction.actionPerformed(actionEvent);
                }
            }
        }, KeyStroke.getKeyStroke(127, 0));
        actionUtility.bindAction((Action)new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultSetTableModel resultSetTableModel = resultSetTable.getResultSetTableModel();
                int n = resultSetTable.getSelectedRow();
                if (n >= 0) {
                    resultSetTableModel.insertUnlinkedRow(n + 1, new Object[resultSetTableModel.getColumnCount()]);
                } else {
                    resultSetTableModel.addUnlinkedRow(new Object[resultSetTableModel.getColumnCount()]);
                }
            }
        }, "addEmptyRow");
        actionUtility.bindAction((Action)new AbstractAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    SmartImporter smartImporter = new SmartImporter(WindowLauncher3.getClipboardAsReader(), "\t");
                    try {
                        Object[] objectArray;
                        ResultSetTableModel resultSetTableModel = resultSetTable.getResultSetTableModel();
                        while ((objectArray = ((Importer)smartImporter).nextRow()).length != 0) {
                            resultSetTableModel.addUnlinkedRow(objectArray);
                            resultSetTableModel.linkRow(resultSetTableModel.getRowCount() - 1);
                        }
                        resultSetTable.repaintRowHeader("model");
                    }
                    finally {
                        ((Importer)smartImporter).close();
                    }
                }
                catch (Exception exception) {
                    WindowLauncher3.handleError(exception, windowOutputProcessor);
                }
                finally {
                    abstractAction.actionPerformed(actionEvent);
                }
            }
        }, "insertFromClipboard");
        actionUtility.bindAction((Action)new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultSetTableModel resultSetTableModel = resultSetTable.getResultSetTableModel();
                Vector<Vector> vector = resultSetTableModel.getDataVector();
                int[] nArray = resultSetTable.getSelectedRows();
                int n = nArray[nArray.length - 1];
                for (int n2 : nArray) {
                    resultSetTableModel.insertUnlinkedRow(++n, (Vector)((Vector)vector.get(n2)).clone());
                }
                resultSetTable.repaint();
                resultSetTable.repaintRowHeader("model");
            }
        }, "duplicateRows");
        actionUtility.bindAction((Action)new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultSetTableModel resultSetTableModel = resultSetTable.getResultSetTableModel();
                try {
                    for (int n : resultSetTable.getSelectedRows()) {
                        resultSetTableModel.linkRow(n);
                    }
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException(sQLException);
                }
                finally {
                    resultSetTable.repaintRowHeader("unlinkedRowStatus");
                }
            }
        }, "linkRowsToDatabase");
        actionUtility.bindAction((Action)new AbstractAction("deleteRows"){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n;
                    ResultSetTableModel resultSetTableModel = resultSetTable.getResultSetTableModel();
                    while ((n = resultSetTable.getSelectedRow()) >= 0) {
                        if (resultSetTableModel.isLinkedRow(n)) {
                            boolean bl = resultSetTableModel.removeLinkedRow(n);
                            assert (bl);
                            continue;
                        }
                        resultSetTableModel.removeRow(n);
                    }
                }
                catch (SQLException sQLException) {
                    throw new RuntimeException(sQLException);
                }
                finally {
                    resultSetTable.repaintRowHeader("model");
                }
            }
        }, KeyStroke.getKeyStroke(45, n | 0x40));
        actionUtility.bindAction((Action)new AbstractAction("sort"){

            public void actionPerformed(ActionEvent actionEvent) {
                windowOutputProcessor.sortTable(resultSetTable.getSelectedColumn());
            }
        }, KeyStroke.getKeyStroke(83, 512));
        actionUtility.bindAction((Action)new AbstractAction("adjustColumnWidth"){

            public void actionPerformed(ActionEvent actionEvent) {
                windowOutputProcessor.adjustTableColumnWidth();
            }
        }, KeyStroke.getKeyStroke(47, n));
        String[] stringArray = new String[]{"copy", "copyWithEscape", "paste", "copyColumnNames", "clearCells", "selectAll", "", "addEmptyRow", "insertFromClipboard", "duplicateRows", "linkRowsToDatabase", "deleteRows"};
        final List<String> list = Arrays.asList("paste", "clearCells", "addEmptyRow", "duplicateRows", "linkRowsToDatabase", "deleteRows");
        final LinkedHashMap<String, JMenuItem> linkedHashMap = new LinkedHashMap<String, JMenuItem>();
        JPopupMenu jPopupMenu = actionUtility.createPopupMenu(stringArray, "CWPNRA EISLD".toCharArray(), linkedHashMap);
        jPopupMenu.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                ResultSetTableModel resultSetTableModel = resultSetTable.getResultSetTableModel();
                boolean bl = resultSetTableModel.isLinkable();
                for (Map.Entry entry : linkedHashMap.entrySet()) {
                    if (!list.contains(entry.getKey())) continue;
                    ((JMenuItem)entry.getValue()).setEnabled(bl);
                }
                boolean bl2 = resultSetTableModel.isUpdatable();
                ((JMenuItem)linkedHashMap.get("insertFromClipboard")).setEnabled(bl2);
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
        resultSetTable.setComponentPopupMenu(jPopupMenu);
        JTableHeader jTableHeader = resultSetTable.getTableHeader();
        JPopupMenu jPopupMenu2 = actionUtility.createPopupMenu(new String[]{"copy", "copyWithEscape", "copyColumnNames", "addEmptyRow", "insertFromClipboard"}, "CWNEI".toCharArray());
        final Point point = new Point();
        JMenuItem jMenuItem = new JMenuItem(new AbstractAction(Resource.getString("Action.sort", Character.valueOf('S'))){

            public void actionPerformed(ActionEvent actionEvent) {
                windowOutputProcessor.sortTable(resultSetTable.getTableHeader().columnAtPoint(point));
            }
        });
        jTableHeader.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                point.setLocation(mouseEvent.getPoint());
            }
        });
        jMenuItem.setMnemonic('S');
        jPopupMenu2.insert(jMenuItem, 0);
        jTableHeader.setComponentPopupMenu(jPopupMenu2);
        ResultSetTable.RowHeader rowHeader = resultSetTable.getRowHeader();
        rowHeader.setComponentPopupMenu(jPopupMenu);
    }

    static void bindEvents(final ConsoleTextArea consoleTextArea, final WindowLauncher windowLauncher) {
        ActionUtility actionUtility = ActionUtility.getInstance(consoleTextArea);
        consoleTextArea.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                windowLauncher.executeCommand(actionEvent.getActionCommand());
            }
        });
        consoleTextArea.setDropTarget(new DropTarget(consoleTextArea, new DropTargetAdapter(){

            public void drop(DropTargetDropEvent dropTargetDropEvent) {
                List list;
                Object object;
                Transferable transferable = dropTargetDropEvent.getTransferable();
                if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    dropTargetDropEvent.acceptDrop(3);
                    try {
                        object = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                        list = object;
                    }
                    catch (UnsupportedFlavorException unsupportedFlavorException) {
                        throw new RuntimeException(unsupportedFlavorException);
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException);
                    }
                } else {
                    throw new IllegalStateException("Transferable=" + transferable);
                }
                object = new JPopupMenu();
                JMenuItem jMenuItem = new JMenuItem(new AbstractAction(Resource.getString("Action.paste-path", Character.valueOf('P'))){

                    public void actionPerformed(ActionEvent actionEvent) {
                        String string = Iteration.join(list, " ");
                        int n = consoleTextArea.getCaretPosition();
                        if (consoleTextArea.isEditablePosition(n)) {
                            consoleTextArea.insert(string, n);
                        } else {
                            consoleTextArea.append(string, false);
                        }
                    }
                });
                jMenuItem.setMnemonic('P');
                ((JPopupMenu)object).add(jMenuItem);
                JMenuItem jMenuItem2 = new JMenuItem(new AbstractAction(Resource.getString("Action.paste-file-content", Character.valueOf('F'))){

                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            for (File file : list) {
                                if (file.length() <= 0L) continue;
                                String string = this.convertContentToString(file);
                                int n = consoleTextArea.getCaretPosition();
                                if (consoleTextArea.isEditablePosition(n)) {
                                    consoleTextArea.insert(string, n);
                                    continue;
                                }
                                consoleTextArea.append(string, false);
                            }
                        }
                        catch (IOException iOException) {
                            throw new RuntimeException(iOException);
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    private String convertContentToString(File file) throws IOException {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        FileInputStream fileInputStream = new FileInputStream(file);
                        try {
                            fileInputStream.getChannel().transferTo(0L, file.length(), Channels.newChannel(byteArrayOutputStream));
                        }
                        finally {
                            fileInputStream.close();
                        }
                        return byteArrayOutputStream.toString();
                    }
                });
                jMenuItem2.setMnemonic('F');
                ((JPopupMenu)object).add(jMenuItem2);
                Point point = dropTargetDropEvent.getLocation();
                ((JPopupMenu)object).show(consoleTextArea, point.x, point.y);
            }
        }));
        actionUtility.setActionForTextComponent();
    }
}

