/*
 *  Copyright 2010 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.stew.ui.window;

import java.awt.*;
import java.awt.datatransfer.*;
import java.io.*;

import net.argius.logging.*;

/**
 * WindowLauncher̕R[h(3)B
 * [eBeB\bhWB
 */
final class WindowLauncher3 {

    private static final Logger log = LoggerFactory.getLogger(WindowLauncher3.class);

    private WindowLauncher3() {
        // empty
    }

    /**
     * Nbv{[h̓e𕶎Xg[ƂĎ擾B
     * @return Xg[
     * @throws IOException
     */
    static Reader getClipboardAsReader() throws IOException {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            return DataFlavor.stringFlavor.getReaderForText(clipboard.getContents(null));
        } catch (UnsupportedFlavorException ex) {
            if (log.isDebugEnabled()) {
                log.debug("", ex);
            }
            throw new IOException(ex.toString());
        }
    }

    /**
     * Nbv{[h當擾B
     * @return 
     * @throws IOException 
     */
    static String getClipboard() throws IOException {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        final Object o;
        try {
            o = clipboard.getData(DataFlavor.stringFlavor);
        } catch (UnsupportedFlavorException ex) {
            if (log.isDebugEnabled()) {
                log.debug("", ex);
            }
            throw new IOException(ex.toString());
        }
        if (log.isTraceEnabled()) {
            log.trace(String.format("get clipboard:[%s]", o));
        }
        return (String)o;
    }

    /**
     * Nbv{[hɕݒ肷B
     * @param s 
     */
    static void setClipboard(String s) {
        if (log.isTraceEnabled()) {
            log.trace(String.format("set clipboard:[%s]", s));
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection sselection = new StringSelection(s);
        clipboard.setContents(sselection, sselection);
    }

    /**
     * G[̏B
     * @param th G[
     * @param op WindowOutputProcessor
     */
    static void handleError(Throwable th, WindowOutputProcessor op) {
        log.error("", th);
        op.showErrorDialog(th);
    }

}
