/*
 *  Copyright 2010 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.stew.command;

import java.io.*;
import java.sql.*;

import net.argius.logging.*;
import net.argius.stew.*;

/**
 * UploadR}hB
 * t@Cf[^w肵ɓo^B
 */
public final class Upload extends Command {

    private static final Logger log = LoggerFactory.getLogger(Upload.class);

    @Override
    public void execute(Connection conn, Parameter parameter) throws CommandException {
        if (!parameter.has(2)) {
            throw new UsageException(getUsage());
        }
        final File file = resolvePath(parameter.at(1));
        final String sql = parameter.after(2);
        if (log.isDebugEnabled()) {
            log.debug("file: " + file.getAbsolutePath());
            log.debug("SQL: " + sql);
        }
        if (file.length() > Integer.MAX_VALUE) {
            throw new CommandException("file too large: " + file);
        }
        final int length = (int)file.length();
        try {
            InputStream is = new FileInputStream(file);
            try {
                PreparedStatement stmt = conn.prepareStatement(sql);
                try {
                    setTimeout(stmt);
                    stmt.setBinaryStream(1, is, length);
                    final int updatedCount = stmt.executeUpdate();
                    outputMessage("i.updated", updatedCount);
                } finally {
                    stmt.close();
                }
            } finally {
                is.close();
            }
        } catch (IOException ex) {
            throw new CommandException(ex);
        } catch (SQLException ex) {
            throw new CommandException(ex);
        }
    }

}
