/*
 *  Copyright 2010 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.stew.io;

import java.io.*;

/**
 * C|[g̊NXB
 *
 * IɑI(getImporter)ꍇA
 * t@C`͈ȉ̂悤Ɋgqɂ莩IɑIB
 * <ul>
 * <li>gq"xml"̏ꍇXML`(stew-table.dtd)Ƃăt@CǂݍށB
 * <li>gq"csv"̏ꍇCSV`Ƃăt@CǂݍށB
 * <li>LȊȌꍇ̓^u؂`Ƃăt@CǂݍށB
 * </ul>
 */
public abstract class Importer {

    protected InputStream is;
    protected boolean wasReadHeader;
    protected boolean closed;

    /**
     * RXgN^B
     * @param is InputStream
     */
    protected Importer(InputStream is) {
        this.is = is;
        this.wasReadHeader = false;
        this.closed = false;
    }

    /**
     * Xg[JĂ邱ƂmFB
     * @throws IOException Xg[ɕĂꍇ
     */
    protected final void ensureOpen() throws IOException {
        if (closed) {
            throw new IOException("stream closed");
        }
    }

    /**
     * wb_擾B
     * @return wb_
     * @throws IOException 
     */
    public Object[] getHeader() throws IOException {
        ensureOpen();
        Object[] header = readHeader();
        wasReadHeader = true;
        return header;
    }

    /**
     * wb_ǂݍށB
     * @return wb_
     * @throws IOException 
     */
    protected Object[] readHeader() throws IOException {
        ensureOpen();
        return nextRow();
    }

    /**
     * IB
     * @throws IOException
     */
    public void close() throws IOException {
        ensureOpen();
        if (is != null) {
            try {
                is.close();
            } finally {
                closed = true;
                is = null;
            }
        }
    }

    /**
     * ImporterIɑIĎ擾B
     * @see Importer
     * @param file t@C
     * @return Importer
     * @throws IOException
     */
    public static Importer getImporter(File file) throws IOException {
        return ImporterFactory.createImporter(new Path(file));
    }

    /**
     * ImporterIɑIĎ擾B
     * @see Importer
     * @param fileName t@C
     * @return Importer
     * @throws IOException
     */
    public static Importer getImporter(String fileName) throws IOException {
        return ImporterFactory.createImporter(new Path(fileName));
    }

    /**
     * ̍sԂB
     * @return s ̍sȂꍇ͋z([̔z)
     * @throws IOException
     */
    public abstract Object[] nextRow() throws IOException;

}