/*
 *  Copyright 2010 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.stew;

import static net.argius.stew.Resource.EMPTY_STRING;

import java.util.*;

/**
 * p[^B
 */
public final class Parameter {

    private final String string;
    private final String[] array;
    private final int[] indices;

    /**
     * RXgN^B
     * @param string p[^
     */
    public Parameter(String string) {
        char[] chars = string.toCharArray();
        int[] indices = indices(chars);
        String[] array = array(chars, indices);
        this.string = string;
        this.array = array;
        this.indices = indices;
    }

    private static int[] indices(char[] chars) {
        List<Integer> a = new ArrayList<Integer>();
        boolean prev = true;
        boolean quoted = false;
        for (int i = 0; i < chars.length; i++) {
            final char c = chars[i];
            if (c == '"') {
                quoted = !quoted;
            }
            final boolean f = isSpaceChar(c);
            if (!f && f != prev) {
                a.add(i);
            }
            prev = !quoted && f;
        }
        a.add(chars.length);
        int[] indices = new int[a.size()];
        for (int i = 0; i < indices.length; i++) {
            indices[i] = a.get(i);
        }
        return indices;
    }

    private static String[] array(char[] chars, int[] indices) {
        String[] a = new String[indices.length - 1];
        for (int i = 0; i < a.length; i++) {
            final int offset = indices[i];
            int end = indices[i + 1];
            while (end > offset) {
                if (!isSpaceChar(chars[end - 1])) {
                    break;
                }
                --end;
            }
            final String s = String.valueOf(chars, offset, end - offset);
            a[i] = (chars[offset] == '"') ? s.substring(1, s.length() - 1) : s;
        }
        return a;
    }

    private static boolean isSpaceChar(char c) {
        switch (c) {
            case '\t':
            case '\n':
            case '\f':
            case '\r':
            case ' ':
                return true;
            default:
        }
        return false;
    }

    /**
     * w肵ʒũp[^擾B
     * @param index ʒu(R}h0)
     * @return p[^
     */
    public String at(int index) {
        return has(index) ? array[index] : EMPTY_STRING;
    }

    /**
     * w肵ʒuȌ̃p[^擾B
     * @param index ʒu(R}h0)
     * @return p[^
     */
    public String after(int index) {
        return has(index) ? string.substring(indices[index]) : EMPTY_STRING;
    }

    /**
     * w肵ʒũp[^݂邩𒲂ׂB
     * @param index ʒu(R}h0)
     * @return 
     */
    public boolean has(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("index >= 0: " + index);
        }
        return index < array.length;
    }

    /**
     * w肵Ԃ̃p[^擾B
     * @param number 
     * @return p[^
     * @deprecated {@link #at(int)}gp(Aindex=number-1)
     */
    @Deprecated
    public String get(int number) {
        if (number < 1) {
            throw new IllegalArgumentException("'number' starts from 1");
        }
        return at(number - 1);
    }

    /**
     * p[^SĎ擾B
     * @return p[^
     * @deprecated {@link #asString()}gp
     */
    @Deprecated
    public String getAll() {
        return string;
    }

    /**
     * w肵Ԉȍ~̃p[^SĎ擾B
     * @param number 
     * @return p[^
     * @deprecated {@link #after(int)}gp(Aindex=number-1)
     */
    @Deprecated
    public String getAll(int number) {
        if (number < 1) {
            throw new IllegalArgumentException("'number' starts from 1");
        }
        return after(number - 1);
    }

    /**
     * w肵Ԃ̃p[^󂩂ǂ𒲂ׂB
     * @param number 
     * @return w肵Ԃ̃p[^󂩂ǂ
     * @deprecated {@link #has(int)}gp(Aindex=number-1)
     */
    @Deprecated
    public boolean isEmpty(int number) {
        return get(number).length() == 0;
    }

    /**
     * p[^zƂĎ擾B
     * @return p[^̔z
     */
    public String[] asArray() {
        return array.clone();
    }

    /**
     * p[^𕶎ƂĎ擾B
     * <code>toString</code>Ƃ͈قȂB
     * @return p[^
     */
    public String asString() {
        return string;
    }

    @Override
    public String toString() {
        return "Parameter[" + string + "]";
    }

}
