/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Scanner;
import net.argius.logging.Logger;
import net.argius.logging.LoggerFactory;
import net.argius.stew.io.Path;

public final class LocalSystem {
    private static final String FILE_PROPERTIES = "stew.properties";
    private static final Logger log = LoggerFactory.getLogger(LocalSystem.class);
    private static File directory = LocalSystem.initializeDirectory();
    private static Properties props = LocalSystem.initializeProperties();

    private LocalSystem() {
    }

    private static File initializeDirectory() {
        File file;
        String string = System.getProperty("net.argius.stew.properties");
        if (string == null) {
            file = new File(".stew");
        } else {
            File file2 = new File(string);
            if (file2.isDirectory()) {
                file = file2;
            } else {
                file = file2.getParentFile();
                if (file == null) {
                    file = new File(".stew");
                }
            }
        }
        try {
            Path.makeDirectory(file);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
        return file;
    }

    private static Properties initializeProperties() {
        Properties properties = System.getProperties();
        Properties properties2 = new Properties(properties);
        try {
            properties2.putAll((Map<?, ?>)LocalSystem.getFileProperties());
        }
        catch (IOException iOException) {
            log.warn("", iOException);
        }
        Properties properties3 = new Properties(properties2);
        if (log.isTraceEnabled()) {
            int n = 3;
            for (Properties properties4 : new Properties[]{properties, properties2}) {
                Object object2;
                ArrayList<String> arrayList = new ArrayList<String>(properties4.size());
                for (Object object2 : properties4.keySet()) {
                    arrayList.add((String)object2);
                }
                Collections.sort(arrayList);
                StringWriter stringWriter = new StringWriter();
                object2 = new PrintWriter(stringWriter);
                ((PrintWriter)object2).println();
                ((PrintWriter)object2).println("--- property group " + n-- + " ---");
                for (String string : arrayList) {
                    ((PrintWriter)object2).println(string + '=' + properties4.getProperty(string));
                }
                log.trace(stringWriter);
            }
        }
        return properties3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getFileProperties() throws IOException {
        InputStream inputStream;
        Object object;
        Properties properties = new Properties();
        String string = System.getProperty("net.argius.stew.properties");
        if (string != null) {
            object = new File(string);
            if (((File)object).isDirectory()) {
                object = new File((File)object, FILE_PROPERTIES);
            }
            if (((File)object).exists()) {
                FileInputStream fileInputStream = new FileInputStream((File)object);
                try {
                    properties.load(fileInputStream);
                    Properties properties2 = properties;
                    return properties2;
                }
                finally {
                    ((InputStream)fileInputStream).close();
                }
            }
        }
        if ((inputStream = LocalSystem.class.getResourceAsStream((String)(object = "/stew.properties"))) != null) {
            try {
                properties.load(inputStream);
                Properties properties3 = properties;
                return properties3;
            }
            finally {
                inputStream.close();
            }
        }
        File file = new File(directory, FILE_PROPERTIES);
        if (file.exists()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                properties.load(fileInputStream);
                Properties properties4 = properties;
                return properties4;
            }
            finally {
                ((InputStream)fileInputStream).close();
            }
        }
        return properties;
    }

    public static File getDirectory() {
        return directory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getVersion() {
        InputStream inputStream = LocalSystem.class.getResourceAsStream("version");
        if (inputStream != null) {
            String string;
            try {
                Scanner scanner = new Scanner(inputStream);
                string = scanner.nextLine();
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
            inputStream.close();
            return string;
        }
        return "unknown";
    }

    public static String getBundleMessage(ResourceBundle resourceBundle, String string, Object ... objectArray) {
        try {
            String string2 = resourceBundle.getString(string);
            if (objectArray.length == 0) {
                return string2;
            }
            return MessageFormat.format(string2, objectArray);
        }
        catch (Exception exception) {
            log.warn(exception);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string.replaceFirst(".*?\\.(.+)", "$1"));
            stringBuilder.setCharAt(0, Character.toUpperCase(stringBuilder.charAt(0)));
            if (!string.startsWith("Menu.")) {
                for (Object object : objectArray) {
                    stringBuilder.append(" " + object);
                }
            }
            return stringBuilder.toString();
        }
    }

    public static String getProperty(String string) {
        return props.getProperty(string, "");
    }

    public static String getProperty(String string, String string2) {
        return props.getProperty(string, string2);
    }

    public static int getPropertyAsInt(String string) {
        return LocalSystem.getPropertyAsInt(string, 0);
    }

    public static int getPropertyAsInt(String string, int n) {
        try {
            String string2 = props.getProperty(string);
            if (string2 != null) {
                return Integer.decode(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return n;
    }

    public static Object setProperty(String string, String string2) {
        return props.setProperty(string, string2);
    }

    public static boolean containsKey(String string) {
        return props.getProperty(string) != null;
    }
}

