/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.ui.window;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassFinder {
    private String rootPath;
    private ClassLoader classLoader;
    private boolean failMode;

    ClassFinder(String string) {
        this.rootPath = ClassFinder.normalizePath(string);
        this.classLoader = ClassLoader.getSystemClassLoader();
    }

    void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    void setFailMode(boolean bl) {
        this.failMode = bl;
    }

    final void find(File file) {
        block11: {
            try {
                File file2 = file.getCanonicalFile();
                if (file2.isDirectory()) {
                    File[] fileArray = file2.listFiles();
                    if (fileArray != null) {
                        for (File file3 : fileArray) {
                            this.find(file3);
                        }
                    }
                    break block11;
                }
                String string = file2.getName();
                if (string.matches("(?i).+\\.class")) {
                    try {
                        this.filter(this.resolveClass(file2.getPath()));
                        break block11;
                    }
                    catch (Throwable throwable) {
                        if (this.failMode) {
                            this.fail(file2, throwable);
                            break block11;
                        }
                        throw new RuntimeException(throwable);
                    }
                }
                if (string.matches("(?i).+\\.(jar|zip)")) {
                    this.find(new ZipFile(file2));
                }
            }
            catch (IOException iOException) {
                if (this.failMode) {
                    this.fail(file, iOException);
                }
                throw new RuntimeException(iOException);
            }
        }
    }

    final void find(ZipFile zipFile) {
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            String string = zipEntry.getName();
            if (!string.matches("(?i).+\\.class")) continue;
            try {
                this.filter(this.resolveClass(string));
            }
            catch (Throwable throwable) {
                if (this.failMode) {
                    this.fail(string, throwable);
                    continue;
                }
                throw new RuntimeException(throwable);
            }
        }
    }

    void filter(Class<?> clazz) {
    }

    void fail(Object object, Throwable throwable) {
    }

    protected final Class<?> resolveClass(String string) throws Throwable {
        String string2 = ClassFinder.normalizePath(string);
        if (string2.startsWith(this.rootPath)) {
            string2 = string2.substring(this.rootPath.length() + 1);
        }
        string2 = string2.replaceFirst("\\.class$", "").replace('/', '.');
        return Class.forName(string2, false, this.classLoader);
    }

    private static String normalizePath(String string) {
        return string.replaceAll("\\\\", "/");
    }
}

