/*
 *  Copyright 2010 argius
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package net.argius.stew;

import static net.argius.stew.Resource.EMPTY_STRING;

import java.util.*;

/**
 * RlN^}bvB
 * RlN^ݒ̊֘AtsB
 */
public final class ConnectorMap extends LinkedHashMap<String, Connector> {

    /**
     * RXgN^B
     */
    public ConnectorMap() {
        // empty
    }

    /**
     * RXgN^B
     * @param idList IDXg
     * @param props ۑԂ̃vpeB
     */
    public ConnectorMap(List<String> idList, Properties props) {
        for (String id : idList) {
            Properties p = new Properties();
            copyPropertyById(id, "name", props, p);
            copyPropertyById(id, "driver", props, p);
            copyPropertyById(id, "classpath", props, p);
            copyPropertyById(id, "url", props, p);
            copyPropertyById(id, "user", props, p);
            copyPropertyById(id, "password", props, p);
            copyPropertyById(id, "password.class", props, p);
            copyPropertyById(id, "readonly", props, p);
            copyPropertyById(id, "rollback", props, p);
            Connector connector = new Connector(id, p);
            put(id, connector);
        }
    }

    /**
     * Rs[RXgN^B
     * @param src Rs[̃CX^X
     */
    public ConnectorMap(ConnectorMap src) {
        putAll(src);
    }

    /**
     * IDƂɃvpeBRs[B
     * @param id ID
     * @param key L[
     * @param src Rs[vpeB
     * @param dst Rs[vpeB
     */
    private void copyPropertyById(String id, String key, Properties src, Properties dst) {
        String fullKey = id + '.' + key;
        String value = src.getProperty(fullKey, EMPTY_STRING);
        dst.setProperty(key, value);
    }

    /**
     * RlN^̎擾B
     * @param id ID
     * @return RlN^
     */
    public Connector getConnector(String id) {
        return get(id);
    }

    /**
     * RlN^̐ݒB
     * @param id ID
     * @param connector RlN^
     */
    public void setConnector(String id, Connector connector) {
        put(id, connector);
    }

    /**
     * vpeBIuWFNg̎擾B
     * @return vpeBIuWFNg
     */
    public Properties toProperties() {
        Properties props = new Properties();
        for (String id : keySet()) {
            Connector connector = getConnector(id);
            Password password = connector.getPassword();
            props.setProperty(id + ".name", connector.getName());
            props.setProperty(id + ".driver", connector.getDriver());
            props.setProperty(id + ".classpath", connector.getClasspath());
            props.setProperty(id + ".url", connector.getUrl());
            props.setProperty(id + ".user", connector.getUser());
            props.setProperty(id + ".password", password.getTransformedString());
            props.setProperty(id + ".password.class", password.getClass().getName());
            props.setProperty(id + ".readonly", Boolean.toString(connector.isReadOnly()));
            props.setProperty(id + ".rollback", Boolean.toString(connector.usesAutoRollback()));
        }
        return props;
    }

}