/*
 * Decompiled with CFR 0.152.
 */
package net.argius.stew.ui.window;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import net.argius.stew.ColumnOrder;
import net.argius.stew.DaemonThreadFactory;
import net.argius.stew.Environment;
import net.argius.stew.Iteration;
import net.argius.stew.LocalSystem;
import net.argius.stew.ResultSetReference;
import net.argius.stew.io.Exporter;
import net.argius.stew.io.Importer;
import net.argius.stew.ui.OutputProcessor;
import net.argius.stew.ui.Prompt;
import net.argius.stew.ui.window.ConsoleTextArea;
import net.argius.stew.ui.window.Menu;
import net.argius.stew.ui.window.Resource;
import net.argius.stew.ui.window.ResultSetTable;
import net.argius.stew.ui.window.ResultSetTableModel;
import net.argius.stew.ui.window.ValueTransporter;

final class WindowOutputProcessor
extends JFrame
implements OutputProcessor {
    private ResultSetTable resultSetTable;
    private ConsoleTextArea textArea;
    private Environment env;
    private File currentDirectory;
    private Menu.Item autoAdjustMode;
    private Menu.Item postProcessMode;
    private int lastSortedIndex;
    private boolean lastSortedIsReverse;

    WindowOutputProcessor(ResultSetTable resultSetTable, ConsoleTextArea consoleTextArea) {
        this.resultSetTable = resultSetTable;
        this.textArea = consoleTextArea;
        this.lastSortedIndex = -1;
        this.lastSortedIsReverse = false;
    }

    public void output(Object object) {
        try {
            if (object instanceof ResultSet) {
                this.outputResult((ResultSet)object, new ColumnOrder(), "");
                return;
            }
            if (object instanceof ResultSetReference) {
                this.outputResult((ResultSetReference)object);
                return;
            }
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
        final ConsoleTextArea consoleTextArea = this.textArea;
        final String string = object instanceof Prompt ? WindowOutputProcessor.replaceEOL(object.toString()) : WindowOutputProcessor.replaceEOL(String.format("%s%n", object));
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                consoleTextArea.output(string);
            }
        });
    }

    public void close() {
        this.dispose();
    }

    void setEnvironment(Environment environment) {
        this.env = environment;
    }

    @Deprecated
    int outputResult(ResultSet resultSet, ColumnOrder columnOrder, String string) throws SQLException {
        ResultSetReference resultSetReference = new ResultSetReference(resultSet, string);
        this.outputResult(resultSetReference);
        return resultSetReference.getRecordCount();
    }

    void outputResult(ResultSetReference resultSetReference) throws SQLException {
        OutputProcessor outputProcessor = this.env.getOutputProcessor();
        final ResultSetTable resultSetTable = this.resultSetTable;
        final JTableHeader jTableHeader = resultSetTable.getTableHeader();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                resultSetTable.setVisible(false);
                jTableHeader.setVisible(false);
                ((DefaultTableModel)resultSetTable.getModel()).setRowCount(0);
            }
        });
        ResultSet resultSet = resultSetReference.getResultSet();
        ColumnOrder columnOrder = resultSetReference.getOrder();
        boolean bl = columnOrder.size() > 0;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = bl ? columnOrder.size() : resultSetMetaData.getColumnCount();
        final ResultSetTableModel resultSetTableModel = new ResultSetTableModel(resultSetReference);
        Vector<Object> vector = new Vector<Object>(n);
        ValueTransporter valueTransporter = ValueTransporter.getInstance("");
        final int n2 = LocalSystem.getPropertyAsInt("net.argius.stew.rowcount.limit", Integer.MAX_VALUE);
        int n3 = 0;
        while (resultSet.next()) {
            if (n3 >= n2) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        WindowOutputProcessor.this.output(Resource.getString("w.exceeded-limit", n2));
                    }
                });
                break;
            }
            ++n3;
            vector.clear();
            for (int i = 0; i < n; ++i) {
                int n4 = bl ? columnOrder.getOrder(i) : i + 1;
                vector.add(valueTransporter.getObject(resultSet, n4));
            }
            resultSetTableModel.addRow((Vector)vector.clone());
            if (this.env.getOutputProcessor() == outputProcessor) continue;
            throw new SQLException("interrupted");
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                resultSetTable.setModel(resultSetTableModel);
                Container container = resultSetTable.getParent();
                if (container != null && container.getParent() instanceof JScrollPane) {
                    JScrollPane jScrollPane = (JScrollPane)container.getParent();
                    ImageIcon imageIcon = Resource.getImageIcon(String.format("linkable-%s.png", resultSetTableModel.isLinkable()));
                    jScrollPane.setCorner("UPPER_LEFT_CORNER", new JLabel(imageIcon, 0));
                }
                WindowOutputProcessor.this.adjustTableColumnWidth();
                jTableHeader.setVisible(true);
                resultSetTable.doLayout();
                resultSetTable.setVisible(true);
            }
        });
        resultSetReference.setRecordCount(resultSetTableModel.getRowCount());
    }

    Menu.Item getAutoAdjustMode() {
        return this.autoAdjustMode;
    }

    void setAutoAdjustMode(Menu.Item item) {
        Menu.Item item2 = this.autoAdjustMode;
        this.autoAdjustMode = item;
        this.firePropertyChange("autoAdjustMode", (Object)item2, (Object)item);
    }

    Menu.Item getPostProcessMode() {
        return this.postProcessMode;
    }

    void setPostProcessMode(Menu.Item item) {
        Menu.Item item2 = this.postProcessMode;
        this.postProcessMode = item;
        this.firePropertyChange("postProcessMode", (Object)item2, (Object)item);
    }

    void changeTableColumnWidth(double d) {
        for (TableColumn tableColumn : Iteration.asIterable(this.resultSetTable.getColumnModel().getColumns())) {
            tableColumn.setPreferredWidth((int)((double)tableColumn.getWidth() * d));
        }
        if (this.resultSetTable.isFocusOwner()) {
            this.resultSetTable.requestFocusInWindow();
        }
    }

    void adjustTableColumnWidth() {
        boolean bl;
        boolean bl2;
        if (this.autoAdjustMode == null) {
            return;
        }
        switch (this.autoAdjustMode) {
            case AUTO_ADJUST_MODE_HEADER: {
                bl2 = true;
                bl = false;
                break;
            }
            case AUTO_ADJUST_MODE_VALUE: {
                bl2 = false;
                bl = true;
                break;
            }
            case AUTO_ADJUST_MODE_HEADERANDVALUE: {
                bl2 = true;
                bl = true;
                break;
            }
            case AUTO_ADJUST_MODE_NONE: {
                bl2 = false;
                bl = false;
                break;
            }
            default: {
                throw new IllegalStateException("autoAdjustMode=" + (Object)((Object)this.autoAdjustMode));
            }
        }
        int n = this.resultSetTable.getRowCount();
        if (!bl2 && bl && n == 0) {
            return;
        }
        float f = (float)this.resultSetTable.getParent().getWidth() * 0.8f;
        TableColumnModel tableColumnModel = this.resultSetTable.getColumnModel();
        JTableHeader jTableHeader = this.resultSetTable.getTableHeader();
        int n2 = this.resultSetTable.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            Object object;
            TableCellRenderer tableCellRenderer;
            float f2 = 0.0f;
            if (bl2) {
                TableColumn tableColumn = tableColumnModel.getColumn(i);
                tableCellRenderer = tableColumn.getHeaderRenderer();
                if (tableCellRenderer == null) {
                    tableCellRenderer = jTableHeader.getDefaultRenderer();
                }
                if (tableCellRenderer != null) {
                    object = tableCellRenderer.getTableCellRendererComponent(this.resultSetTable, tableColumn.getHeaderValue(), false, false, 0, i);
                    f2 = (float)((Component)object).getPreferredSize().width * 1.5f;
                }
            }
            if (bl) {
                for (int j = 0; j < n; ++j) {
                    tableCellRenderer = this.resultSetTable.getCellRenderer(j, i);
                    if (tableCellRenderer == null) continue;
                    object = this.resultSetTable.getValueAt(j, i);
                    Component component = tableCellRenderer.getTableCellRendererComponent(this.resultSetTable, object, false, false, j, i);
                    if ((f2 = Math.max(f2, (float)component.getPreferredSize().width)) >= f) break;
                }
            }
            int n3 = Math.round(f2 > f ? f : f2) + 1;
            tableColumnModel.getColumn(i).setPreferredWidth(n3);
        }
    }

    void doPostProcess() {
        final ConsoleTextArea consoleTextArea = this.textArea;
        final Runnable runnable = new Runnable(){

            public void run() {
                WindowOutputProcessor.this.requestFocus();
                consoleTextArea.requestFocusInWindow();
            }
        };
        if (this.isActive()) {
            EventQueue.invokeLater(runnable);
            return;
        }
        String string = this.getClass().getName() + ".postprocess.";
        final int n = LocalSystem.getPropertyAsInt(string + "count", 32);
        final int n2 = LocalSystem.getPropertyAsInt(string + "range", 2);
        final long l = LocalSystem.getPropertyAsInt(string + "interval", 50);
        switch (this.postProcessMode) {
            case POST_PROCESS_MODE_NONE: {
                break;
            }
            case POST_PROCESS_MODE_FOCUS: {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        WindowOutputProcessor.this.toFront();
                        runnable.run();
                    }
                });
                break;
            }
            case POST_PROCESS_MODE_SHAKE: {
                DaemonThreadFactory.execute(new Runnable(){

                    public void run() {
                        Runnable runnable = new Runnable(){
                            int sign = -1;

                            public void run() {
                                this.sign *= -1;
                                WindowOutputProcessor.this.setLocation(WindowOutputProcessor.this.getX() + n2 * this.sign, WindowOutputProcessor.this.getY());
                            }
                        };
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                consoleTextArea.requestFocusInWindow();
                            }
                        });
                        int n3 = n >> 1 << 1;
                        for (int i = 0; i < n3; ++i) {
                            EventQueue.invokeLater(runnable);
                            WindowOutputProcessor.sleep(l);
                        }
                    }
                });
                break;
            }
            case POST_PROCESS_MODE_BLINK: {
                DaemonThreadFactory.execute(new Runnable(){

                    public void run() {
                        final byte[] byArray = new byte[]{0};
                        final JPanel jPanel = new JPanel(){

                            protected void paintComponent(Graphics graphics) {
                                super.paintComponent(graphics);
                                graphics.setColor(new Color(0, 230, 46, byArray[0] & 0xFF));
                                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                            }
                        };
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                consoleTextArea.requestFocusInWindow();
                                WindowOutputProcessor.this.setGlassPane(jPanel);
                                jPanel.setOpaque(false);
                                jPanel.setVisible(true);
                            }
                        });
                        int n3 = (n / 45 + 1) * 45;
                        for (int i = 0; i < n3; ++i) {
                            byArray[0] = (byte)((Math.sin((float)i * 0.25f) + 1.0) * 32.0 * (double)n2);
                            jPanel.repaint();
                            WindowOutputProcessor.sleep(l);
                        }
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                jPanel.setVisible(false);
                                WindowOutputProcessor.this.remove(jPanel);
                            }
                        });
                    }
                });
                break;
            }
            default: {
                throw new IllegalStateException("postProcessMode=" + (Object)((Object)this.postProcessMode));
            }
        }
    }

    static void sleep(long l) {
        block2: {
            try {
                TimeUnit.MILLISECONDS.sleep(l);
            }
            catch (InterruptedException interruptedException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)interruptedException.toString());
            }
        }
    }

    void sortTable(int n) {
        boolean bl;
        if (this.lastSortedIndex == n) {
            bl = !this.lastSortedIsReverse;
        } else {
            this.lastSortedIndex = n;
            bl = false;
        }
        this.lastSortedIsReverse = bl;
        this.resultSetTable.getResultSetTableModel().sort(n, bl);
        this.resultSetTable.repaint();
        this.resultSetTable.repaintRowHeader("unlinkedRowStatus");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void importIntoCurrentTable() throws IOException, SQLException {
        ResultSetTableModel resultSetTableModel;
        if (this.env.getCurrentConnection() == null) {
            JOptionPane.showMessageDialog(this, Resource.getString("w.not-connect", new Object[0]));
            return;
        }
        TableModel tableModel = this.resultSetTable.getModel();
        boolean bl = tableModel instanceof ResultSetTableModel ? (resultSetTableModel = (ResultSetTableModel)tableModel).isLinkable() && resultSetTableModel.isSameConnection(this.env.getCurrentConnection()) : false;
        if (!bl) {
            JOptionPane.showMessageDialog(this, Resource.getString("w.import-target-not-available", new Object[0]));
            return;
        }
        resultSetTableModel = (ResultSetTableModel)tableModel;
        assert (this.currentDirectory != null);
        JFileChooser jFileChooser = new JFileChooser(this.currentDirectory);
        jFileChooser.setDialogTitle(Resource.getString("Action.import", new Object[0]));
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.showOpenDialog(this);
        File file = jFileChooser.getSelectedFile();
        if (file == null) {
            return;
        }
        this.setCurrentDirectory(file);
        Importer importer = Importer.getImporter(file);
        try {
            Object[] objectArray;
            while ((objectArray = importer.nextRow()).length != 0) {
                resultSetTableModel.addUnlinkedRow(objectArray);
                resultSetTableModel.linkRow(resultSetTableModel.getRowCount() - 1);
            }
        }
        finally {
            importer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void exportTableContent() throws IOException {
        assert (this.currentDirectory != null);
        JFileChooser jFileChooser = new JFileChooser(this.currentDirectory);
        jFileChooser.setDialogTitle(Resource.getString("Action.export", new Object[0]));
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.showSaveDialog(this);
        File file = jFileChooser.getSelectedFile();
        if (file == null) {
            return;
        }
        this.setCurrentDirectory(file);
        if (file.exists() && JOptionPane.showConfirmDialog(this, Resource.getString("i.confirm-overwrite", file), "", 0) != 0) {
            return;
        }
        Exporter exporter = Exporter.getExporter(file);
        try {
            TableColumnModel tableColumnModel = this.resultSetTable.getTableHeader().getColumnModel();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (TableColumn serializable2 : Iteration.asIterable(tableColumnModel.getColumns())) {
                arrayList.add(serializable2.getHeaderValue());
            }
            exporter.addHeader(arrayList.toArray());
            DefaultTableModel defaultTableModel = (DefaultTableModel)this.resultSetTable.getModel();
            Vector<Vector> vector = defaultTableModel.getDataVector();
            for (Vector vector2 : vector) {
                exporter.addRow(vector2.toArray());
            }
        }
        finally {
            exporter.close();
        }
        JOptionPane.showMessageDialog(this, Resource.getString("i.exported", new Object[0]));
    }

    private void setCurrentDirectory(File file) {
        File file2 = file.isDirectory() ? file : file.getParentFile();
        assert (file2.isDirectory());
        this.currentDirectory = file2;
    }

    void showInformationMessageDialog(String string, String string2) {
        WindowOutputProcessor.showInformationMessageDialog(this, string, string2);
    }

    static void showInformationMessageDialog(Component component, String string, String string2) {
        JTextArea jTextArea = new JTextArea(string, 6, 60);
        WindowOutputProcessor.setupReadOnlyTextArea(jTextArea);
        JOptionPane.showMessageDialog(component, new JScrollPane(jTextArea), string2, 1);
    }

    void showErrorDialog(Throwable throwable) {
        WindowOutputProcessor.showErrorDialog(this, throwable);
    }

    static void showErrorDialog(final Component component, Throwable throwable) {
        JPanel jPanel = new JPanel(new BorderLayout());
        String string = Resource.getString("e.error", new Object[0]);
        if (throwable == null) {
            jPanel.add((Component)new JLabel(Resource.getString("e.error-no-detail", new Object[0])), "Center");
        } else {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            final String string2 = WindowOutputProcessor.replaceEOL(((Object)stringWriter).toString());
            JTextArea jTextArea = new JTextArea(throwable.getMessage(), 6, 60);
            WindowOutputProcessor.setupReadOnlyTextArea(jTextArea);
            jPanel.add((Component)new JScrollPane(jTextArea), "Center");
            JPanel jPanel2 = new JPanel();
            jPanel.add((Component)jPanel2, "After");
            jPanel2.add(new JButton(new AbstractAction(Resource.getString("Action.detail", new Object[0])){

                public void actionPerformed(ActionEvent actionEvent) {
                    JEditorPane jEditorPane = new JEditorPane("text/plain", string2);
                    jEditorPane.setCaretPosition(0);
                    jEditorPane.setEditable(false);
                    JScrollPane jScrollPane = new JScrollPane(jEditorPane);
                    JOptionPane jOptionPane = new JOptionPane(jScrollPane, -1, -1);
                    JDialog jDialog = jOptionPane.createDialog(component, "");
                    jDialog.setResizable(true);
                    if (component == null) {
                        Rectangle rectangle = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
                        jDialog.setSize(rectangle.width / 3, rectangle.height / 4);
                    } else {
                        Dimension dimension = component.getSize();
                        dimension.width = (int)((double)dimension.width * 1.5);
                        dimension.height = (int)((double)dimension.height * 0.9);
                        jDialog.setSize(dimension);
                    }
                    jDialog.setLocationRelativeTo(component);
                    jDialog.setVisible(true);
                }
            }));
        }
        JOptionPane.showMessageDialog(component, jPanel, string, 0);
    }

    private static String replaceEOL(String string) {
        return string.replaceAll("\\\r\\\n?", "\n");
    }

    static void setupReadOnlyTextArea(JTextArea jTextArea) {
        jTextArea.setEditable(false);
        jTextArea.setWrapStyleWord(false);
        jTextArea.setLineWrap(true);
        jTextArea.setOpaque(false);
        jTextArea.setMargin(new Insets(4, 4, 4, 4));
    }

    static final class Bypass
    implements OutputProcessor {
        private OutputProcessor op;
        private volatile boolean closed;

        Bypass(OutputProcessor outputProcessor) {
            this.op = outputProcessor;
        }

        public void output(Object object) {
            if (!this.closed) {
                this.op.output(object);
            }
        }

        public void close() {
            this.closed = true;
        }
    }
}

